<?php
header('Content-Type: text/html; charset=utf-8');

$controller = isset($_GET['controller']) ? $_GET['controller'] : 'buyBillController';
$mdFile = __DIR__ . "/controllers/{$controller}.md";

if (!file_exists($mdFile)) {
    die("Documentation file not found: {$controller}.md");
}

$markdown = file_get_contents($mdFile);

function parseFlowchart($text) {
    $lines = explode("\n", $text);
    $html = '<div class="flowchart-container">';
    
    foreach ($lines as $line) {
        $line = htmlspecialchars($line);
        
        if (strpos($line, '┌─') !== false || strpos($line, '└─') !== false) {
            $html .= '<div class="flow-box-border">' . $line . '</div>';
        } elseif (strpos($line, 'START:') !== false || strpos($line, 'END:') !== false) {
            $html .= '<div class="flow-step flow-start">' . strip_tags(str_replace(['│', '┌', '┐', '└', '┘', '─'], '', $line)) . '</div>';
        } elseif (preg_match('/^\s*│\s+(\d+)\.\s+(.+)│\s*$/', $line, $matches)) {
            $stepNum = $matches[1];
            $stepText = $matches[2];
            $html .= '<div class="flow-step" data-step="' . $stepNum . '"><span class="step-number">' . $stepNum . '</span>' . $stepText . '</div>';
        } elseif (preg_match('/│\s+(.+?)\s+│/', $line, $matches)) {
            $content = trim($matches[1]);
            if (strpos($content, 'FOR EACH') !== false || strpos($content, 'IF') !== false) {
                $html .= '<div class="flow-step flow-decision">' . $content . '</div>';
            } elseif (strpos($content, '├─→') !== false || strpos($content, '└─→') !== false) {
                $html .= '<div class="flow-substep">' . str_replace(['├─→', '└─→', '│'], ['→', '→', ''], $content) . '</div>';
            } else {
                $html .= '<div class="flow-step">' . $content . '</div>';
            }
        } elseif (trim($line) === '│' || strpos($line, '▼') !== false) {
            $html .= '<div class="flow-arrow">▼</div>';
        }
    }
    
    $html .= '</div>';
    return $html;
}

function parseMarkdown($text) {
    $placeholders = [];
    $counter = 0;
    
    $text = preg_replace_callback('/```(\w+)?\s*\n(.*?)\n```/s', function($matches) use (&$placeholders, &$counter) {
        $lang = isset($matches[1]) && $matches[1] ? $matches[1] : '';
        $code = $matches[2];
        
        if (strpos($code, '┌─') !== false || strpos($code, '│') !== false || strpos($code, 'START:') !== false) {
            $flowchart = parseFlowchart($code);
            $placeholder = "___FLOWCHART_{$counter}___";
            $placeholders[$placeholder] = $flowchart;
        } else {
            $code = htmlspecialchars($code);
            $displayLang = $lang ?: 'code';
            $placeholder = "___CODE_BLOCK_{$counter}___";
            $placeholders[$placeholder] = "<pre class='code-block {$displayLang}'><code>{$code}</code></pre>";
        }
        $counter++;
        return $placeholder;
    }, $text);
    
    $text = preg_replace_callback('/(\|.+\|[\r\n]+)((?:\|[-:\s|]+\|[\r\n]+))(((?:\|.+\|[\r\n]+)+))/m', function($matches) use (&$placeholders, &$counter) {
        $headerLine = trim($matches[1]);
        $bodyLines = trim($matches[3]);
        
        $headerCells = array_map('trim', explode('|', trim($headerLine, '|')));
        $bodyRows = array_filter(explode("\n", $bodyLines));
        
        $html = '<table><thead><tr>';
        foreach ($headerCells as $cell) {
            $html .= '<th>' . trim($cell) . '</th>';
        }
        $html .= '</tr></thead><tbody>';
        
        foreach ($bodyRows as $row) {
            $cells = array_map('trim', explode('|', trim($row, '|')));
            $html .= '<tr>';
            foreach ($cells as $cell) {
                $html .= '<td>' . trim($cell) . '</td>';
            }
            $html .= '</tr>';
        }
        
        $html .= '</tbody></table>';
        
        $placeholder = "___TABLE_{$counter}___";
        $placeholders[$placeholder] = $html;
        $counter++;
        return $placeholder;
    }, $text);
    
    $text = preg_replace('/`([^`\n]+)`/', '<code>$1</code>', $text);
    
    $text = preg_replace('/^# (.+)$/m', '<h1>$1</h1>', $text);
    $text = preg_replace('/^## (.+)$/m', '<h2>$1</h2>', $text);
    $text = preg_replace('/^### (.+)$/m', '<h3>$1</h3>', $text);
    $text = preg_replace('/^#### (.+)$/m', '<h4>$1</h4>', $text);
    
    $text = preg_replace('/\*\*(.+?)\*\*/', '<strong>$1</strong>', $text);
    $text = preg_replace('/(?<!\*)\*([^\*\n]+)\*(?!\*)/', '<em>$1</em>', $text);
    
    $text = preg_replace('/^\- \[x\] (.+)$/m', '<li class="checked">✅ $1</li>', $text);
    $text = preg_replace('/^\- \[ \] (.+)$/m', '<li class="unchecked">◻️ $1</li>', $text);
    $text = preg_replace('/^\- (.+)$/m', '<li>• $1</li>', $text);
    
    $text = preg_replace_callback('/\[(.+?)\]\((.+?)\)/', function($matches) {
        $url = $matches[2];
        $text = $matches[1];
        
        if (preg_match('/^(.+?)\.md$/', $url, $mdMatch)) {
            $controllerName = $mdMatch[1];
            $url = "?controller={$controllerName}";
        }
        
        return "<a href='{$url}'>{$text}</a>";
    }, $text);
    
    $text = preg_replace('/^---+$/m', '<hr>', $text);
    
    $lines = explode("\n", $text);
    $inList = false;
    $result = [];
    
    foreach ($lines as $line) {
        if (preg_match('/^<li/', $line)) {
            if (!$inList) {
                $result[] = '<ul>';
                $inList = true;
            }
            $result[] = $line;
        } else {
            if ($inList) {
                $result[] = '</ul>';
                $inList = false;
            }
            if (trim($line) !== '' && !preg_match('/^<(h[1-4]|hr|table|pre|div)/', $line)) {
                $line = '<p>' . $line . '</p>';
            }
            $result[] = $line;
        }
    }
    if ($inList) {
        $result[] = '</ul>';
    }
    
    $text = implode("\n", $result);
    
    foreach ($placeholders as $placeholder => $content) {
        $text = str_replace($placeholder, $content, $text);
    }
    
    return $text;
}

$html = parseMarkdown($markdown);
?>
<!DOCTYPE html>
<html dir="ltr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo ucfirst($controller); ?> Documentation</title>
    
    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({
                pageLanguage: 'en',
                includedLanguages: 'en,ar',
                layout: google.translate.TranslateElement.InlineLayout.SIMPLE,
                autoDisplay: false
            }, 'google_translate_element');
        }
    </script>
    <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
    
    <style>
        /* Google Translate Styling */
        #google_translate_element {
            background: #1a202c;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 10px;
        }
        
        .goog-te-combo {
            background: #2d3748;
            color: #e2e8f0;
            border: 1px solid #4a5568;
            padding: 8px 12px;
            border-radius: 6px;
            font-size: 13px;
            width: 100%;
            cursor: pointer;
        }
        
        .goog-te-combo:hover {
            border-color: #667eea;
        }
        
        .goog-te-gadget {
            color: #a0aec0 !important;
            font-size: 0 !important;
        }
        
        .goog-te-gadget .goog-te-combo {
            margin: 4px 0;
            color: #e2e8f0 !important;
        }
        
        /* Hide Google Translate branding */
        .goog-logo-link {
            display: none !important;
        }
        
        .goog-te-gadget > span > a {
            display: none !important;
        }
        
        .goog-te-banner-frame {
            display: none !important;
        }
        
        body {
            top: 0 !important;
        }
        
        .skiptranslate iframe {
            visibility: hidden !important;
            height: 0 !important;
        }
    </style>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f7fafc;
            margin: 0;
            padding: 0;
            line-height: 1.6;
            display: flex;
            height: 100vh;
            overflow: hidden;
        }
        
        .sidebar {
            width: 300px;
            background: #2d3748;
            color: white;
            display: flex;
            flex-direction: column;
            height: 100vh;
            position: fixed;
            left: 0;
            top: 0;
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
            z-index: 1000;
        }
        
        .sidebar-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px;
            text-align: center;
            flex-shrink: 0;
        }
        
        .sidebar-header h1 {
            font-size: 1.3em;
            margin: 0;
            color: white;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        
        .sidebar-header p {
            font-size: 0.85em;
            margin: 5px 0 0 0;
            opacity: 0.9;
        }
        
        .nav-container {
            flex: 1;
            overflow-y: auto;
            overflow-x: hidden;
            padding: 15px;
        }
        
        .main-content {
            margin-left: 300px;
            flex: 1;
            display: flex;
            flex-direction: column;
            height: 100vh;
            overflow: hidden;
        }
        
        .content-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 40px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            flex-shrink: 0;
        }
        
        .content-header h2 {
            margin: 0;
            font-size: 1.8em;
        }
        
        .content {
            flex: 1;
            overflow-y: auto;
            padding: 40px;
            background: white;
        }
        
        .search-box {
            margin-bottom: 15px;
            position: sticky;
            top: 0;
            background: #2d3748;
            padding: 10px 0;
            z-index: 10;
        }
        
        .search-box input {
            width: 100%;
            padding: 10px 15px;
            font-size: 14px;
            border: 2px solid #4a5568;
            border-radius: 6px;
            background: #1a202c;
            color: white;
            outline: none;
            transition: all 0.3s;
        }
        
        .search-box input:focus {
            border-color: #667eea;
            box-shadow: 0 0 8px rgba(102, 126, 234, 0.5);
        }
        
        .search-box input::placeholder {
            color: #a0aec0;
        }
        
        .nav-categories {
            display: flex;
            flex-direction: column;
            gap: 5px;
            padding-bottom: 20px;
        }
        
        /* Custom scrollbar for sidebar */
        .nav-container::-webkit-scrollbar {
            width: 8px;
        }
        
        .nav-container::-webkit-scrollbar-track {
            background: #1a202c;
            border-radius: 4px;
        }
        
        .nav-container::-webkit-scrollbar-thumb {
            background: #4a5568;
            border-radius: 4px;
        }
        
        .nav-container::-webkit-scrollbar-thumb:hover {
            background: #667eea;
        }
        
        .category {
            background: transparent;
            border-radius: 6px;
            overflow: hidden;
            margin-bottom: 3px;
        }
        
        .category-header {
            background: #1a202c;
            color: white;
            padding: 8px 12px;
            cursor: pointer;
            font-weight: 600;
            font-size: 13px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.2s;
            border-radius: 4px;
        }
        
        .category-header:hover {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .category-header .toggle {
            transition: transform 0.3s;
            font-size: 11px;
            opacity: 0.7;
        }
        
        .category.collapsed .toggle {
            transform: rotate(-90deg);
        }
        
        .category-content {
            display: flex;
            flex-direction: column;
            padding: 5px 8px;
            gap: 2px;
            max-height: 400px;
            overflow-y: auto;
            transition: all 0.3s;
        }
        
        .category.collapsed .category-content {
            max-height: 0;
            padding: 0 8px;
            overflow: hidden;
        }
        
        .category-content::-webkit-scrollbar {
            width: 5px;
        }
        
        .category-content::-webkit-scrollbar-track {
            background: transparent;
        }
        
        .category-content::-webkit-scrollbar-thumb {
            background: #4a5568;
            border-radius: 3px;
        }
        
        .category-content a {
            color: #e2e8f0;
            text-decoration: none;
            padding: 6px 10px;
            background: transparent;
            border-radius: 4px;
            transition: all 0.2s;
            display: block;
            font-size: 12px;
            border-left: 2px solid transparent;
        }
        
        .category-content a:hover {
            background: #4a5568;
            border-left-color: #667eea;
            transform: translateX(3px);
        }
        
        .category-content a.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            font-weight: bold;
            border-left-color: #f7fafc;
        }
        
        h1 {
            color: #667eea;
            font-size: 2.5em;
            margin: 30px 0 20px 0;
            border-bottom: 4px solid #667eea;
            padding-bottom: 10px;
        }
        
        h2 {
            color: #764ba2;
            font-size: 2em;
            margin: 30px 0 0 0;
            padding: 15px;
            padding-left: 50px;
            background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
            border-left: 5px solid #764ba2;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s;
            position: relative;
        }
        
        h2:hover {
            background: linear-gradient(135deg, #edf2f7 0%, #e2e8f0 100%);
            transform: translateX(5px);
        }
        
        h2:before {
            content: '▼';
            position: absolute;
            left: 15px;
            transition: transform 0.3s;
        }
        
        h2.collapsed:before {
            transform: rotate(-90deg);
        }
        
        .section-content {
            max-height: 5000px;
            overflow: hidden;
            transition: max-height 0.5s ease-out, opacity 0.3s;
            opacity: 1;
            padding: 0 15px;
        }
        
        .section-content.collapsed {
            max-height: 0;
            opacity: 0;
            padding: 0;
        }
        
        h3 {
            color: #4a5568;
            font-size: 1.5em;
            margin: 25px 0 10px 0;
            padding-left: 10px;
            border-left: 3px solid #4a5568;
        }
        
        h4 {
            color: #718096;
            font-size: 1.2em;
            margin: 20px 0 10px 0;
        }
        
        p {
            margin: 10px 0;
            color: #2d3748;
            line-height: 1.8;
        }
        
        ul {
            margin: 15px 0;
            padding-left: 20px;
        }
        
        code {
            background: #f7fafc;
            padding: 2px 6px;
            border-radius: 3px;
            color: #e53e3e;
            font-family: 'Courier New', monospace;
            font-size: 0.9em;
        }
        
        .code-block {
            background: #2d3748;
            color: #68d391;
            padding: 20px;
            border-radius: 8px;
            overflow-x: auto;
            margin: 20px 0;
            border-left: 5px solid #667eea;
        }
        
        .code-block.php {
            border-left-color: #8993be;
        }
        
        .code-block.sql {
            border-left-color: #f6ad55;
        }
        
        .code-block code {
            background: transparent;
            color: #68d391;
            padding: 0;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        thead {
            background: #667eea;
            color: white;
        }
        
        th {
            padding: 15px;
            text-align: left;
            font-weight: bold;
            border-right: 1px solid rgba(255,255,255,0.2);
        }
        
        tbody tr {
            border-bottom: 1px solid #e2e8f0;
        }
        
        tbody tr:nth-child(even) {
            background: #f7fafc;
        }
        
        tbody tr:hover {
            background: #edf2f7;
        }
        
        td {
            padding: 12px;
            border-right: 1px solid #e2e8f0;
        }
        
        td:first-child {
            font-weight: bold;
            color: #667eea;
        }
        
        .flowchart-container {
            background: linear-gradient(135deg, #f7fafc 0%, #fff 100%);
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 30px;
            margin: 30px 0;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        
        .flow-step {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 25px;
            margin: 15px auto;
            border-radius: 12px;
            max-width: 600px;
            box-shadow: 0 4px 8px rgba(102, 126, 234, 0.3);
            position: relative;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .flow-step:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
        }
        
        .flow-step.flow-start {
            background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
            font-weight: bold;
            font-size: 1.1em;
            text-align: center;
        }
        
        .flow-step.flow-decision {
            background: linear-gradient(135deg, #f6ad55 0%, #ed8936 100%);
            border-radius: 8px;
            clip-path: polygon(10% 0%, 90% 0%, 100% 50%, 90% 100%, 10% 100%, 0% 50%);
            padding: 25px 40px;
        }
        
        .flow-substep {
            background: #edf2f7;
            color: #2d3748;
            padding: 12px 20px;
            margin: 8px auto 8px 60px;
            border-left: 4px solid #667eea;
            border-radius: 6px;
            max-width: 550px;
            font-size: 0.95em;
        }
        
        .flow-arrow {
            text-align: center;
            color: #667eea;
            font-size: 2em;
            margin: 5px 0;
            animation: bounce 2s infinite;
        }
        
        @keyframes bounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(5px); }
        }
        
        .step-number {
            background: rgba(255,255,255,0.3);
            padding: 5px 12px;
            border-radius: 20px;
            margin-right: 10px;
            font-weight: bold;
            font-size: 0.9em;
        }
        
        .flow-box-border {
            display: none;
        }
        
        li {
            margin: 8px 0;
            margin-left: 20px;
            color: #2d3748;
        }
        
        li.checked {
            color: #38a169;
            font-weight: bold;
            list-style: none;
            margin-left: 0;
        }
        
        li.unchecked {
            color: #a0aec0;
            list-style: none;
            margin-left: 0;
        }
        
        hr {
            border: none;
            border-top: 2px solid #e2e8f0;
            margin: 30px 0;
        }
        
        a {
            color: #667eea;
            text-decoration: none;
            border-bottom: 1px dotted #667eea;
            transition: all 0.3s;
        }
        
        a:hover {
            color: #764ba2;
            border-bottom-color: #764ba2;
        }
        
        strong {
            color: #2d3748;
            font-weight: 700;
        }
        
        .toc {
            background: #f7fafc;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 5px solid #667eea;
        }
        
        .toc h3 {
            color: #667eea;
            border: none;
            padding: 0;
            margin-top: 0;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 0.85em;
            font-weight: bold;
            margin: 0 5px;
        }
        
        .badge.success {
            background: #c6f6d5;
            color: #22543d;
        }
        
        .badge.warning {
            background: #feebc8;
            color: #7c2d12;
        }
        
        .badge.info {
            background: #bee3f8;
            color: #2c5282;
        }
        
        .scroll-top {
            position: fixed;
            bottom: 30px;
            right: 30px;
            background: #667eea;
            color: white;
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
            transition: all 0.3s;
            opacity: 0;
            pointer-events: none;
            z-index: 999;
        }
        
        .scroll-top.visible {
            opacity: 1;
            pointer-events: auto;
        }
        
        .scroll-top:hover {
            background: #764ba2;
            transform: translateY(-5px);
        }
        
        /* Badge for controller count */
        .badge {
            background: rgba(102, 126, 234, 0.2);
            color: #667eea;
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 11px;
            font-weight: bold;
            margin-left: 5px;
        }
        
        /* Search highlight */
        mark.highlight {
            background: #fbbf24;
            color: #1f2937;
            padding: 2px 4px;
            border-radius: 3px;
            font-weight: bold;
        }
        
        /* Search box enhancements */
        .search-box {
            position: relative;
        }
        
        .search-box::after {
            content: '💡 Tip: Search by controller name or description';
            position: absolute;
            bottom: -18px;
            left: 0;
            font-size: 10px;
            color: #a0aec0;
            opacity: 0;
            transition: opacity 0.3s;
        }
        
        .search-box input:focus + ::after,
        .search-box:hover::after {
            opacity: 1;
        }
        
        @media print {
            .sidebar {
                display: none;
            }
            .main-content {
                margin-left: 0;
            }
            .content-header, .scroll-top {
                display: none;
            }
        }
        
        @media (max-width: 768px) {
            .sidebar {
                width: 250px;
            }
            .main-content {
                margin-left: 250px;
            }
        }
    </style>
</head>
<body>
    <!-- Fixed Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <h1>📚 ERP Docs</h1>
            <p>384 Controllers Documented</p>
        </div>
        
        <div class="nav-container">
            <!-- Language Selector -->
            <div id="google_translate_element"></div>
            
            <div class="search-box">
                <input type="text" id="docSearch" placeholder="🔍 Search controllers..." onkeyup="debounceSearch()">
                <div id="searchResults" style="display: none; padding: 8px; background: #1a202c; color: #a0aec0; font-size: 11px; border-radius: 4px; margin-top: 8px;"></div>
            </div>
            
            <div id="noResults" style="display: none; padding: 20px; text-align: center; color: #a0aec0; font-size: 13px;">
                <div style="font-size: 40px; margin-bottom: 10px;">🔍</div>
                <div>No controllers found</div>
                <div style="font-size: 11px; margin-top: 5px; opacity: 0.7;">Try a different search term</div>
            </div>
            
            <div class="nav-categories">
<?php include(__DIR__ . '/navigation_menu.php'); ?>
            </div>
        </div>
    </div>

    <!-- Main Content Area -->
    <div class="main-content">
        <div class="content-header">
            <h2><?php echo ucfirst(str_replace(['Controller', '.php'], '', $controller)); ?> Documentation</h2>
        </div>
        
        <div class="content">
            <?php echo $html; ?>
        </div>
    </div>
    
    <div class="scroll-top" id="scrollTop" onclick="scrollToTop()">
        ↑
    </div>
    
    <script>
        function toggleCategory(categoryId) {
            const category = document.getElementById(categoryId).parentElement;
            category.classList.toggle('collapsed');
        }
        
        function filterDocs() {
            const searchText = document.getElementById('docSearch').value.toLowerCase();
            const categories = document.querySelectorAll('.category');
            const searchResults = document.getElementById('searchResults');
            const noResults = document.getElementById('noResults');
            let totalMatches = 0;
            let visibleCategories = 0;
            
            if (searchText === '') {
                // Reset: show all categories, collapse all
                categories.forEach(category => {
                    category.style.display = 'block';
                    category.classList.add('collapsed');
                    const links = category.querySelectorAll('.category-content a');
                    links.forEach(link => {
                        link.style.display = 'block';
                    });
                });
                searchResults.style.display = 'none';
                noResults.style.display = 'none';
                return;
            }
            
            categories.forEach(category => {
                const links = category.querySelectorAll('.category-content a');
                let hasVisibleLink = false;
                
                links.forEach(link => {
                    const linkText = link.textContent.toLowerCase();
                    const href = link.getAttribute('href') || '';
                    const controllerName = href.replace('?controller=', '').toLowerCase();
                    
                    // Search in: link text, controller name, and extract words
                    const searchableText = linkText + ' ' + controllerName;
                    
                    if (searchableText.includes(searchText)) {
                        link.style.display = 'block';
                        hasVisibleLink = true;
                        totalMatches++;
                        
                        // Highlight matching text
                        const originalText = link.innerHTML;
                        const regex = new RegExp(`(${searchText})`, 'gi');
                        link.innerHTML = originalText.replace(/<mark class="highlight">|<\/mark>/g, '');
                        link.innerHTML = link.innerHTML.replace(regex, '<mark class="highlight">$1</mark>');
                    } else {
                        link.style.display = 'none';
                    }
                });
                
                if (hasVisibleLink) {
                    category.style.display = 'block';
                    category.classList.remove('collapsed'); // Expand categories with matches
                    visibleCategories++;
                } else {
                    category.style.display = 'none';
                }
            });
            
            // Show results count or no results message
            if (totalMatches > 0) {
                searchResults.style.display = 'block';
                searchResults.innerHTML = `✓ Found ${totalMatches} controller${totalMatches > 1 ? 's' : ''} in ${visibleCategories} categor${visibleCategories > 1 ? 'ies' : 'y'}`;
                noResults.style.display = 'none';
            } else {
                searchResults.style.display = 'none';
                noResults.style.display = 'block';
            }
        }
        
        // Clear highlights when search is cleared
        function clearHighlights() {
            const links = document.querySelectorAll('.category-content a');
            links.forEach(link => {
                link.innerHTML = link.innerHTML.replace(/<mark class="highlight">|<\/mark>/g, '');
            });
        }
        
        // Enhanced search with debounce
        let searchTimeout;
        function debounceSearch() {
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(() => {
                const searchText = document.getElementById('docSearch').value.toLowerCase();
                if (searchText === '') {
                    clearHighlights();
                }
                filterDocs();
            }, 150);
        }
        
        // Scroll to top button for main content area
        const contentArea = document.querySelector('.content');
        if (contentArea) {
            contentArea.addEventListener('scroll', function() {
                const scrollTop = document.getElementById('scrollTop');
                if (contentArea.scrollTop > 300) {
                    scrollTop.classList.add('visible');
                } else {
                    scrollTop.classList.remove('visible');
                }
            });
        }
        
        function scrollToTop() {
            const contentArea = document.querySelector('.content');
            if (contentArea) {
                contentArea.scrollTo({
                    top: 0,
                    behavior: 'smooth'
                });
            }
        }
        
        
        function makeAccordions() {
            const contentDiv = document.querySelector('.content');
            const h2Elements = Array.from(contentDiv.querySelectorAll('h2'));
            
            h2Elements.forEach(function(h2) {
                const wrapper = document.createElement('div');
                wrapper.className = 'section-content collapsed';
                
                let nextElement = h2.nextElementSibling;
                
                while (nextElement && nextElement.tagName !== 'H2' && nextElement.tagName !== 'H1') {
                    const currentElement = nextElement;
                    nextElement = nextElement.nextElementSibling;
                    wrapper.appendChild(currentElement);
                }
                
                h2.parentNode.insertBefore(wrapper, h2.nextSibling);
                
                h2.classList.add('collapsed');
                
                h2.addEventListener('click', function() {
                    this.classList.toggle('collapsed');
                    wrapper.classList.toggle('collapsed');
                });
            });
        }
        
        window.addEventListener('load', function() {
            setTimeout(makeAccordions, 200);
            
            // Auto-expand category containing the active controller
            setTimeout(function() {
                const activeLink = document.querySelector('.category-content a.active');
                if (activeLink) {
                    const parentCategory = activeLink.closest('.category');
                    if (parentCategory) {
                        parentCategory.classList.remove('collapsed');
                        
                        // Scroll the active link into view in the sidebar
                        activeLink.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }
                }
            }, 300);
        });
        
        const expandAllBtn = document.createElement('button');
        expandAllBtn.innerHTML = '📂 Expand All';
        expandAllBtn.style.cssText = 'position: fixed; bottom: 90px; right: 30px; background: #48bb78; color: white; padding: 12px 20px; border: none; border-radius: 25px; cursor: pointer; box-shadow: 0 4px 12px rgba(0,0,0,0.3); font-weight: bold; z-index: 1000; transition: all 0.3s;';
        document.body.appendChild(expandAllBtn);
        
        const collapseAllBtn = document.createElement('button');
        collapseAllBtn.innerHTML = '📁 Collapse All';
        collapseAllBtn.style.cssText = 'position: fixed; bottom: 150px; right: 30px; background: #f56565; color: white; padding: 12px 20px; border: none; border-radius: 25px; cursor: pointer; box-shadow: 0 4px 12px rgba(0,0,0,0.3); font-weight: bold; z-index: 1000; transition: all 0.3s;';
        document.body.appendChild(collapseAllBtn);
        
        expandAllBtn.addEventListener('click', function() {
            document.querySelectorAll('.content h2').forEach(function(h2) {
                h2.classList.remove('collapsed');
                const nextDiv = h2.nextElementSibling;
                if (nextDiv && nextDiv.classList.contains('section-content')) {
                    nextDiv.classList.remove('collapsed');
                }
            });
        });
        
        collapseAllBtn.addEventListener('click', function() {
            document.querySelectorAll('.content h2').forEach(function(h2) {
                h2.classList.add('collapsed');
                const nextDiv = h2.nextElementSibling;
                if (nextDiv && nextDiv.classList.contains('section-content')) {
                    nextDiv.classList.add('collapsed');
                }
            });
        });
        
        expandAllBtn.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-3px)';
            this.style.background = '#38a169';
        });
        expandAllBtn.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.background = '#48bb78';
        });
        
        collapseAllBtn.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-3px)';
            this.style.background = '#e53e3e';
        });
        collapseAllBtn.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.background = '#f56565';
        });
    </script>
</body>
</html>
