<?php
// Script to fix PHP 8.0+ curly brace syntax in PHPExcel library
// Changes $string{$index} to $string[$index]

$phpexcel_dir = '/Applications/AMPPS/www/erp19/library/Classes/PHPExcel/';

// Find all PHP files
$files = new RecursiveIteratorIterator(
    new RecursiveDirectoryIterator($phpexcel_dir),
    RecursiveIteratorIterator::SELF_FIRST
);

$fixed_count = 0;
$file_count = 0;

foreach ($files as $file) {
    if ($file->isFile() && $file->getExtension() === 'php') {
        $filepath = $file->getPathname();
        $content = file_get_contents($filepath);
        
        // Check if file has curly brace syntax
        if (preg_match('/\$[a-zA-Z_][a-zA-Z0-9_]*\{/', $content)) {
            // Replace $var{index} with $var[index]
            // This regex finds: $variable{something}
            $new_content = preg_replace(
                '/(\$[a-zA-Z_][a-zA-Z0-9_]*)\{([^}]+)\}/',
                '$1[$2]',
                $content
            );
            
            if ($new_content !== $content) {
                file_put_contents($filepath, $new_content);
                $file_count++;
                $matches_count = preg_match_all('/\$[a-zA-Z_][a-zA-Z0-9_]*\{/', $content);
                $fixed_count += $matches_count;
                echo "Fixed: " . basename($filepath) . " ($matches_count replacements)\n";
            }
        }
    }
}

echo "\n========================================\n";
echo "Total files fixed: $file_count\n";
echo "Total replacements: $fixed_count\n";
echo "========================================\n";
?>
