<?php

/*
 * this function created to used easy class upload
 * every function have job
 * you can add more function and modied without damage other
 * function used in files
 */

require_once 'class.upload.php';

//upload new image with random name
#$filename for input file name
#$boolresize with true or false to resize image
#$width for image width
#$height for image hieght
#$uploadfolder the desitation folder > must be in upload folder
#$imageNewName the retun name of the upload image
#$uploadtype the upload type
function uploadnew($filename, $boolresize, $width, $height, $uploadfolder, $uploadtype = 1) {
    //create random name for image ,that will be upload
    $randomname = md5(uniqid(mt_rand(), true));
    //upload image by using the classes
    $handle = new upload($_FILES[$filename]);
    $imageNewName = "no image";
    //using the upload classes
    if ($handle->uploaded) {
        $handle->image_interlace = true;
        $handle->image_resize = $boolresize;
        $handle->image_x = $width;
        $handle->image_y = $height;

        if ($uploadtype == 1) {
            $handle->allowed = array('image/*');
        } elseif($uploadtype == 2) {
            $handle->allowed = array('application/pdf');
        }elseif($uploadtype == 7) {
            // allow all
        }else{
            $handle->allowed = array('application/pdf', 'application/msword', 'application/x-zip', 'image/*');
        }
        $handle->file_new_name_body = $randomname;
        $handle->process("../upload/" . $uploadfolder);
        if ($handle->processed) {
            $handle->clean();

            $imageNewName = $randomname . "." . $handle->file_src_name_ext;
        }else {
            //echo 'error : ' . $handle->error;
        }
    }
    #end of image upload
    return $imageNewName;
}



function uploadMultiNew($filename, $boolresize, $width, $height, $uploadfolder, $uploadtype = TRUE)
{

    $files = array();
    foreach ($_FILES[$filename] as $k => $l) {
        foreach ($l as $i => $v) {
            if (!array_key_exists($i, $files))
                $files[$i] = array();
            $files[$i][$k] = $v;
        }
    }

    $images_names = array();
    foreach ($files as $file) {
        //create random name for image ,that will be upload
        $randomname = md5(uniqid(mt_rand(), true));
        //upload image by using the classes
        $handle = new upload($file);
        $imageNewName = "no image";
        //using the upload classes
        if ($handle->uploaded) {
            $handle->image_interlace = true;
            $handle->image_resize = $boolresize;
            $handle->image_x = $width;
            $handle->image_y = $height;
            // $handle->image_ratio = true;

            if ($uploadtype) {
                $handle->allowed = array('image/*');
            } else {
                $handle->allowed = array('application/pdf', 'application/msword', 'application/x-zip', 'image/*', 'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            }
            $handle->file_new_name_body = $randomname;
            $handle->process("../upload/" . $uploadfolder);
            if ($handle->processed) {
                //$handle->clean();
                $imageNewName = $randomname . "." . $handle->file_src_name_ext;

            }
        }
        array_push($images_names, $imageNewName);
    }
    #end of image upload
    return $images_names;
}

//upload update image with random name
#$filename for input file name
#$boolresize with true or false to resize image
#$width for image width
#$height for image hieght
#$uploadfolder the desitation folder > must be in upload folder
#$imageNewName the retun name of the upload image
#$oldname is old image name
#$uploadtype the upload type
function uploadupdate($filename, $oldname, $boolresize, $width, $height, $uploadfolder, $uploadtype = 1) {

    $imageUrl = filter_input(INPUT_POST, $oldname);
    //create random name for image ,that will be upload
    $randomname = md5(uniqid(mt_rand(), true));
    //upload image by using the classes
    $handle = new upload($_FILES[$filename]);
    $imageNewName = $imageUrl;
    //using the upload classes
    if ($handle->uploaded) {
        $handle->image_interlace = true;
        $handle->image_resize = $boolresize;
        $handle->image_x = $width;
        $handle->image_y = $height;
        if ($uploadtype == 1) {
            $handle->allowed = array('image/*');
        } elseif($uploadtype == 2) {
            $handle->allowed = array('application/pdf');
        }else{
            $handle->allowed = array('application/pdf', 'application/msword', 'application/x-zip', 'image/*');
        }
        $handle->file_new_name_body = $randomname;
        $handle->process("../upload/" . $uploadfolder);
        if ($handle->processed) {
            $handle->clean();
            //delete old image
            if ($imageNewName == "no image") {

            } else {
                if (file_exists('../upload/' . $uploadfolder . '/' . $imageNewName)) {
                    //echo $imageNewName;
                    chmod('../upload/' . $uploadfolder . '/' . $imageNewName, 0777);
                    unlink('../upload/' . $uploadfolder . '/' . $imageNewName);
                }
            }

            $imageNewName = $randomname . "." . $handle->file_src_name_ext;
        }
    }
    #end of image upload
    return $imageNewName;
}



