<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-04-24 12:54
 */
interface AccountstreesettingDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Accountstreesetting 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param accountstreesetting primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Accountstreesetting accountstreesetting
 	 */
	public function insert($accountstreesetting);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Accountstreesetting accountstreesetting
 	 */
	public function update($accountstreesetting);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByLevelno($value);

	public function queryByNooffields($value);


	public function deleteByLevelno($value);

	public function deleteByNooffields($value);


}
?>