<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2025-07-13 15:05
 */
interface AdsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Ads 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param ad primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Ads ad
 	 */
	public function insert($ad);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Ads ad
 	 */
	public function update($ad);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTitle($value);

	public function queryByTitleEn($value);

	public function queryByDescription($value);

	public function queryByDescriptionEn($value);

	public function queryByImage($value);

	public function queryByLocation($value);

	public function queryByIsActive($value);

	public function queryBySysDate($value);

	public function queryByUserid($value);

	public function queryByIsdel($value);


	public function deleteByTitle($value);

	public function deleteByTitleEn($value);

	public function deleteByDescription($value);

	public function deleteByDescriptionEn($value);

	public function deleteByImage($value);

	public function deleteByLocation($value);

	public function deleteByIsActive($value);

	public function deleteBySysDate($value);

	public function deleteByUserid($value);

	public function deleteByIsdel($value);


}
?>