<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2025-07-22 12:34
 */
interface BillprinterDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billprinter 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billprinter primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billprinter billprinter
 	 */
	public function insert($billprinter);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billprinter billprinter
 	 */
	public function update($billprinter);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByCats($value);

	public function queryByUserids($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByName($value);

	public function deleteByCats($value);

	public function deleteByUserids($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>