<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2025-07-07 19:05
 */
interface BoardingDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Boarding 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param boarding primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Boarding boarding
 	 */
	public function insert($boarding);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Boarding boarding
 	 */
	public function update($boarding);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTitle($value);

	public function queryByTitleEn($value);

	public function queryByTitleUrl($value);

	public function queryByOpenTarget($value);

	public function queryByImage($value);

	public function queryByContent($value);

	public function queryByContentEn($value);

	public function queryByPosition($value);

	public function queryByIsActive($value);

	public function queryBySysDate($value);

	public function queryByUserid($value);

	public function queryByIsdel($value);


	public function deleteByTitle($value);

	public function deleteByTitleEn($value);

	public function deleteByTitleUrl($value);

	public function deleteByOpenTarget($value);

	public function deleteByImage($value);

	public function deleteByContent($value);

	public function deleteByContentEn($value);

	public function deleteByPosition($value);

	public function deleteByIsActive($value);

	public function deleteBySysDate($value);

	public function deleteByUserid($value);

	public function deleteByIsdel($value);


}
?>