<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2022-01-05 22:09
 */
interface BuybilldetailofferDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Buybilldetailoffer 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param buybilldetailoffer primary key
 	 */
	public function delete($buybilldetailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Buybilldetailoffer buybilldetailoffer
 	 */
	public function insert($buybilldetailoffer);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Buybilldetailoffer buybilldetailoffer
 	 */
	public function update($buybilldetailoffer);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByParcode($value);

	public function queryByBuybillid($value);

	public function queryByBuybilldetailcatid($value);

	public function queryByBuybilldetailproductid($value);

	public function queryByBuybilldetailquantity($value);

	public function queryByBuybilldetailprice($value);

	public function queryByBuybilldetailtotalprice($value);

	public function queryByDiscountvalue($value);

	public function queryByNote($value);

	public function queryByBuybilldetaildate($value);

	public function queryByProductunitid($value);

	public function queryByLastbuyprice($value);

	public function queryByMeanbuyprice($value);

	public function queryByLastbuypriceWithDiscount($value);

	public function queryByMeanbuypriceWithDiscount($value);

	public function queryByOtherdetailquantity($value);

	public function queryBySizeid($value);

	public function queryByColorid($value);

	public function queryByQuantitybefore($value);

	public function queryByBuybilldetailpriceC($value);

	public function queryByBuybilldetailtotalpriceC($value);

	public function queryByDiscountvalueC($value);

	public function queryByDiscountper($value);

	public function queryByDiscounttype($value);


	public function deleteByParcode($value);

	public function deleteByBuybillid($value);

	public function deleteByBuybilldetailcatid($value);

	public function deleteByBuybilldetailproductid($value);

	public function deleteByBuybilldetailquantity($value);

	public function deleteByBuybilldetailprice($value);

	public function deleteByBuybilldetailtotalprice($value);

	public function deleteByDiscountvalue($value);

	public function deleteByNote($value);

	public function deleteByBuybilldetaildate($value);

	public function deleteByProductunitid($value);

	public function deleteByLastbuyprice($value);

	public function deleteByMeanbuyprice($value);

	public function deleteByLastbuypriceWithDiscount($value);

	public function deleteByMeanbuypriceWithDiscount($value);

	public function deleteByOtherdetailquantity($value);

	public function deleteBySizeid($value);

	public function deleteByColorid($value);

	public function deleteByQuantitybefore($value);

	public function deleteByBuybilldetailpriceC($value);

	public function deleteByBuybilldetailtotalpriceC($value);

	public function deleteByDiscountvalueC($value);

	public function deleteByDiscountper($value);

	public function deleteByDiscounttype($value);


}
?>