<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2025-06-12 00:37
 */
interface ClientproductreviewDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Clientproductreview 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param clientproductreview primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Clientproductreview clientproductreview
 	 */
	public function insert($clientproductreview);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Clientproductreview clientproductreview
 	 */
	public function update($clientproductreview);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByProductid($value);

	public function queryByRating($value);

	public function queryByReview($value);

	public function queryBySysDate($value);


	public function deleteByClientid($value);

	public function deleteByProductid($value);

	public function deleteByRating($value);

	public function deleteByReview($value);

	public function deleteBySysDate($value);


}
?>