<?php

/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-04-18 15:43
 */
interface DailyentryDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @Return Dailyentry
     */
    public function load($id);

    /**
     * Get all records from table
     */
    public function queryAll();

    /**
     * Get all records from table ordered by field
     * @Param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn);

    /**
     * Delete record from table
     * @param dailyentry primary key
     */
    public function delete($id);

    /**
     * Insert record to table
     *
     * @param Dailyentry dailyentry
     */
    public function insert($dailyentry);

    /**
     * Update record in table
     *
     * @param Dailyentry dailyentry
     */
    public function update($dailyentry);

    /**
     * Delete all rows
     */
    public function clean();

    public function queryByTotalcreditor($value);

    public function queryByTotaldebtor($value);

    public function queryByThedate($value);

    public function queryByUserid($value);

    public function queryByCondition($value);

    public function queryByReverseofid($value);

    public function queryByDDateTime($value);

    public function queryByCostcenterid($value);

    public function deleteByTotalcreditor($value);

    public function deleteByTotaldebtor($value);

    public function deleteByThedate($value);

    public function deleteByUserid($value);

    public function deleteByCondition($value);

    public function deleteByReverseofid($value);

    public function deleteByDDateTime($value);

    public function deleteByCostcenterid($value);
}

?>