<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-04-18 15:43
 */
interface DailyentrydebtorDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Dailyentrydebtor 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param dailyentrydebtor primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Dailyentrydebtor dailyentrydebtor
 	 */
	public function insert($dailyentrydebtor);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Dailyentrydebtor dailyentrydebtor
 	 */
	public function update($dailyentrydebtor);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByDailyentryid($value);

	public function queryByAccountstreeid($value);

	public function queryByValue($value);

	public function queryByDComment($value);


	public function deleteByDailyentryid($value);

	public function deleteByAccountstreeid($value);

	public function deleteByValue($value);

	public function deleteByDComment($value);


}
?>