<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MCheckDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MCheck 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mCheck primary key
 	 */
	public function delete($checkId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MCheck mCheck
 	 */
	public function insert($mCheck);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MCheck mCheck
 	 */
	public function update($mCheck);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOurSerial($value);

	public function queryByUserId($value);

	public function queryByStageFrom($value);

	public function queryByCheckDate($value);

	public function queryByBranchId($value);

	public function queryByDel($value);


	public function deleteByOurSerial($value);

	public function deleteByUserId($value);

	public function deleteByStageFrom($value);

	public function deleteByCheckDate($value);

	public function deleteByBranchId($value);

	public function deleteByDel($value);


}
?>