<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
interface MComreceiptimageDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return MComreceiptimage 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param mComreceiptimage primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param MComreceiptimage mComreceiptimage
 	 */
	public function insert($mComreceiptimage);
	
	/**
 	 * Update record in table
 	 *
 	 * @param MComreceiptimage mComreceiptimage
 	 */
	public function update($mComreceiptimage);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByComreceiptid($value);

	public function queryByReceiptimage($value);

	public function queryByImagedate($value);

	public function queryByUserid($value);


	public function deleteByComreceiptid($value);

	public function deleteByReceiptimage($value);

	public function deleteByImagedate($value);

	public function deleteByUserid($value);


}
?>