<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2025-05-13 00:19
 */
interface PagesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Pages 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param page primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Pages page
 	 */
	public function insert($page);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Pages page
 	 */
	public function update($page);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByTitle($value);

	public function queryByTitleEn($value);

	public function queryByContentOrExternalLink($value);

	public function queryByExternalLink($value);

	public function queryByOpenTarget($value);

	public function queryByContent($value);

	public function queryByContentEn($value);

	public function queryByIsActive($value);

	public function queryByImage($value);

	public function queryBySysDate($value);

	public function queryByUserid($value);

	public function queryByIsdel($value);


	public function deleteByTitle($value);

	public function deleteByTitleEn($value);

	public function deleteByContentOrExternalLink($value);

	public function deleteByExternalLink($value);

	public function deleteByOpenTarget($value);

	public function deleteByContent($value);

	public function deleteByContentEn($value);

	public function deleteByIsActive($value);

	public function deleteByImage($value);

	public function deleteBySysDate($value);

	public function deleteByUserid($value);

	public function deleteByIsdel($value);


}
?>