<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 11:00
 */
interface PaymentnetworksDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Paymentnetworks 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param paymentnetwork primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Paymentnetworks paymentnetwork
 	 */
	public function insert($paymentnetwork);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Paymentnetworks paymentnetwork
 	 */
	public function update($paymentnetwork);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByDeleted($value);


	public function deleteByName($value);

	public function deleteByDeleted($value);


}
?>