<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-07 17:42
 */
interface ProductionorderDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionorder 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionorder primary key
 	 */
	public function delete($productionOrderid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionorder productionorder
 	 */
	public function insert($productionorder);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionorder productionorder
 	 */
	public function update($productionorder);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByOrderDate($value);

	public function queryByBranchId($value);

	public function queryByStartDate($value);

	public function queryByEndDate($value);

	public function queryByProductId($value);

	public function queryByStageId($value);

	public function queryByOutQuantity($value);

	public function queryByMeasureUnitId($value);

	public function queryByConditions($value);

	public function queryByUserId($value);

	public function queryByOrderStatus($value);


	public function deleteByName($value);

	public function deleteByOrderDate($value);

	public function deleteByBranchId($value);

	public function deleteByStartDate($value);

	public function deleteByEndDate($value);

	public function deleteByProductId($value);

	public function deleteByStageId($value);

	public function deleteByOutQuantity($value);

	public function deleteByMeasureUnitId($value);

	public function deleteByConditions($value);

	public function deleteByUserId($value);

	public function deleteByOrderStatus($value);


}
?>