<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2022-10-26 23:15
 */
interface ProductionoutDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionout 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionout primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionout productionout
 	 */
	public function insert($productionout);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionout productionout
 	 */
	public function update($productionout);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOutStore($value);

	public function queryByInStore($value);

	public function queryBySupplier($value);

	public function queryByProductid($value);

	public function queryBySizeid($value);

	public function queryByColorid($value);

	public function queryByOutQuantity($value);

	public function queryByOutUnitCost($value);

	public function queryByOutAllCost($value);

	public function queryByComment($value);

	public function queryByUserid($value);

	public function queryBySysDate($value);

	public function queryByDel($value);


	public function deleteByOutStore($value);

	public function deleteByInStore($value);

	public function deleteBySupplier($value);

	public function deleteByProductid($value);

	public function deleteBySizeid($value);

	public function deleteByColorid($value);

	public function deleteByOutQuantity($value);

	public function deleteByOutUnitCost($value);

	public function deleteByOutAllCost($value);

	public function deleteByComment($value);

	public function deleteByUserid($value);

	public function deleteBySysDate($value);

	public function deleteByDel($value);


}
?>