<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface RawmaterialscategoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Rawmaterialscategory 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param rawmaterialscategory primary key
 	 */
	public function delete($rawmaterialscategoryid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Rawmaterialscategory rawmaterialscategory
 	 */
	public function insert($rawmaterialscategory);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Rawmaterialscategory rawmaterialscategory
 	 */
	public function update($rawmaterialscategory);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRawmaterialscategoryname($value);

	public function queryByRawmaterialscategorydescription($value);

	public function queryByTempdelete($value);

	public function queryByCurrentdate($value);


	public function deleteByRawmaterialscategoryname($value);

	public function deleteByRawmaterialscategorydescription($value);

	public function deleteByTempdelete($value);

	public function deleteByCurrentdate($value);


}
?>