<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-09-25 17:22
 */
interface ResturantcategoryDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Resturantcategory 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param resturantcategory primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Resturantcategory resturantcategory
 	 */
	public function insert($resturantcategory);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Resturantcategory resturantcategory
 	 */
	public function update($resturantcategory);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCategoryId($value);

	public function queryByDate($value);


	public function deleteByCategoryId($value);

	public function deleteByDate($value);


}
?>