<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 11:55
 */
interface SparepartDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Sparepart 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param sparepart primary key
 	 */
	public function delete($sparepartid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Sparepart sparepart
 	 */
	public function insert($sparepart);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Sparepart sparepart
 	 */
	public function update($sparepart);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySparepartname($value);

	public function queryBySparepartprice($value);

	public function queryBySparepartnotes($value);

	public function queryByUserid($value);

	public function queryBySparepartdate($value);

	public function queryByConditions($value);


	public function deleteBySparepartname($value);

	public function deleteBySparepartprice($value);

	public function deleteBySparepartnotes($value);

	public function deleteByUserid($value);

	public function deleteBySparepartdate($value);

	public function deleteByConditions($value);


}
?>