<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 11:55
 */
interface SparepartstoredetailsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Sparepartstoredetails 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param sparepartstoredetail primary key
 	 */
	public function delete($sparepartstoredetailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Sparepartstoredetails sparepartstoredetail
 	 */
	public function insert($sparepartstoredetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Sparepartstoredetails sparepartstoredetail
 	 */
	public function update($sparepartstoredetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySparepartid($value);

	public function queryBySparepartstoreId($value);

	public function queryByPartquantity($value);

	public function queryByUserid($value);

	public function queryBySparepartstoredetaildate($value);


	public function deleteBySparepartid($value);

	public function deleteBySparepartstoreId($value);

	public function deleteByPartquantity($value);

	public function deleteByUserid($value);

	public function deleteBySparepartstoredetaildate($value);


}
?>