<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-12-14 16:01
 */
interface TamweenclientdetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Tamweenclientdetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tamweenclientdetail primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Tamweenclientdetail tamweenclientdetail
 	 */
	public function insert($tamweenclientdetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Tamweenclientdetail tamweenclientdetail
 	 */
	public function update($tamweenclientdetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByNoOfPersonsTamween($value);

	public function queryByNoOfPersonsDa3m($value);

	public function queryByCardNum($value);

	public function queryByCardPassword($value);


	public function deleteByClientid($value);

	public function deleteByNoOfPersonsTamween($value);

	public function deleteByNoOfPersonsDa3m($value);

	public function deleteByCardNum($value);

	public function deleteByCardPassword($value);


}
?>