<?php

/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-26 14:08
 */
interface ToworkshoporderDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @Return Toworkshoporder
     */
    public function load($id);

    /**
     * Get all records from table
     */
    public function queryAll();

    /**
     * Get all records from table ordered by field
     * @Param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn);

    /**
     * Delete record from table
     * @param toworkshoporder primary key
     */
    public function delete($id);

    /**
     * Insert record to table
     *
     * @param Toworkshoporder toworkshoporder
     */
    public function insert($toworkshoporder);

    /**
     * Update record in table
     *
     * @param Toworkshoporder toworkshoporder
     */
    public function update($toworkshoporder);

    /**
     * Delete all rows
     */
    public function clean();

    public function queryByOrderNo($value);

    public function queryByDriverId($value);

    public function queryByWorkshopId($value);

    public function queryByProductNo($value);

    public function queryByDeliverWorkshopDate($value);

    public function queryByDeliverId($value);

    public function queryByBranchId($value);

    public function queryByOrderStatus($value);

    public function queryBySysDate($value);

    public function queryByDel($value);

    public function queryByUserid($value);

    public function deleteByOrderNo($value);

    public function deleteByDriverId($value);

    public function deleteByWorkshopId($value);

    public function deleteByProductNo($value);

    public function deleteByDeliverWorkshopDate($value);

    public function deleteByDeliverId($value);

    public function deleteByBranchId($value);

    public function deleteByOrderStatus($value);

    public function deleteBySysDate($value);

    public function deleteByDel($value);

    public function deleteByUserid($value);
}

?>