<?php

/**
 * Class that operate on table 'accountmovement'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class AccountmovementMySqlDAO implements AccountmovementDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return AccountmovementMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM accountmovement WHERE accountmovementid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM accountmovement';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM accountmovement ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param accountmovement primary key
     */
    public function delete($accountmovementid) {
        $sql = 'DELETE FROM accountmovement WHERE accountmovementid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($accountmovementid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param AccountmovementMySql accountmovement
     */
    public function insert($accountmovement) {
        $sql = 'INSERT INTO accountmovement (accountmovementbefore, accountmovementamount, accountmovementafter, accountmovementtype, processname, accountmovementmodelid, accountmovementdate, userid, accountid, tablename, bankid, accountmovementcomment, accountmovementkindid,clientdebtchangeidfk,clientid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($accountmovement->accountmovementbefore);
        $sqlQuery->set($accountmovement->accountmovementamount);
        $sqlQuery->set($accountmovement->accountmovementafter);
        $sqlQuery->setNumber($accountmovement->accountmovementtype);
        $sqlQuery->set($accountmovement->processname);
        $sqlQuery->setNumber($accountmovement->accountmovementmodelid);
        $sqlQuery->set($accountmovement->accountmovementdate);
        $sqlQuery->setNumber($accountmovement->userid);
        $sqlQuery->setNumber($accountmovement->accountid);
        $sqlQuery->set($accountmovement->tablename);
        $sqlQuery->setNumber($accountmovement->bankid);
        $sqlQuery->set($accountmovement->accountmovementcomment);
        $sqlQuery->setNumber((int) $accountmovement->accountmovementkindid);
        $sqlQuery->setNumber((int) $accountmovement->clientdebtchangeidfk);
        $sqlQuery->setNumber((int) $accountmovement->clientid);
        $id = $this->executeInsert($sqlQuery);
        $accountmovement->accountmovementid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param AccountmovementMySql accountmovement
     */
    public function update($accountmovement) {
        $sql = 'UPDATE accountmovement SET accountmovementbefore = ?, accountmovementamount = ?, accountmovementafter = ?, accountmovementtype = ?, processname = ?, accountmovementmodelid = ?, accountmovementdate = ?, userid = ?, accountid = ?, tablename = ?, bankid = ?, accountmovementcomment = ?, accountmovementkindid = ?,clientdebtchangeidfk=?,clientid=? WHERE accountmovementid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($accountmovement->accountmovementbefore);
        $sqlQuery->set($accountmovement->accountmovementamount);
        $sqlQuery->set($accountmovement->accountmovementafter);
        $sqlQuery->setNumber($accountmovement->accountmovementtype);
        $sqlQuery->set($accountmovement->processname);
        $sqlQuery->setNumber($accountmovement->accountmovementmodelid);
        $sqlQuery->set($accountmovement->accountmovementdate);
        $sqlQuery->setNumber($accountmovement->userid);
        $sqlQuery->setNumber($accountmovement->accountid);
        $sqlQuery->set($accountmovement->tablename);
        $sqlQuery->setNumber($accountmovement->bankid);
        $sqlQuery->set($accountmovement->accountmovementcomment);
        $sqlQuery->setNumber((int) $accountmovement->accountmovementkindid);
        $sqlQuery->setNumber((int) $accountmovement->clientdebtchangeidfk);
        $sqlQuery->setNumber((int) $accountmovement->clientid);
        $sqlQuery->setNumber($accountmovement->accountmovementid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM accountmovement';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByAccountmovementbefore($value) {
        $sql = 'SELECT * FROM accountmovement WHERE accountmovementbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountmovementamount($value) {
        $sql = 'SELECT * FROM accountmovement WHERE accountmovementamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountmovementafter($value) {
        $sql = 'SELECT * FROM accountmovement WHERE accountmovementafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountmovementtype($value) {
        $sql = 'SELECT * FROM accountmovement WHERE accountmovementtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProcessname($value) {
        $sql = 'SELECT * FROM accountmovement WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountmovementmodelid($value) {
        $sql = 'SELECT * FROM accountmovement WHERE accountmovementmodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountmovementdate($value) {
        $sql = 'SELECT * FROM accountmovement WHERE accountmovementdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM accountmovement WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountid($value) {
        $sql = 'SELECT * FROM accountmovement WHERE accountid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM accountmovement WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBankid($value) {
        $sql = 'SELECT * FROM accountmovement WHERE bankid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByAccountmovementbefore($value) {
        $sql = 'DELETE FROM accountmovement WHERE accountmovementbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountmovementamount($value) {
        $sql = 'DELETE FROM accountmovement WHERE accountmovementamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountmovementafter($value) {
        $sql = 'DELETE FROM accountmovement WHERE accountmovementafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountmovementtype($value) {
        $sql = 'DELETE FROM accountmovement WHERE accountmovementtype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProcessname($value) {
        $sql = 'DELETE FROM accountmovement WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountmovementmodelid($value) {
        $sql = 'DELETE FROM accountmovement WHERE accountmovementmodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountmovementdate($value) {
        $sql = 'DELETE FROM accountmovement WHERE accountmovementdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM accountmovement WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountid($value) {
        $sql = 'DELETE FROM accountmovement WHERE accountid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM accountmovement WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBankid($value) {
        $sql = 'DELETE FROM accountmovement WHERE bankid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return AccountmovementMySql
     */
    protected function readRow($row) {
        $accountmovement = new Accountmovement();

        $accountmovement->accountmovementid = isset($row['accountmovementid']) ? $row['accountmovementid'] : '';
        $accountmovement->accountmovementbefore = isset($row['accountmovementbefore']) ? $row['accountmovementbefore'] : '';
        $accountmovement->accountmovementamount = isset($row['accountmovementamount']) ? $row['accountmovementamount'] : '';
        $accountmovement->accountmovementafter = isset($row['accountmovementafter']) ? $row['accountmovementafter'] : '';
        $accountmovement->accountmovementtype = isset($row['accountmovementtype']) ? $row['accountmovementtype'] : '';
        $accountmovement->processname = isset($row['processname']) ? $row['processname'] : '';
        $accountmovement->accountmovementmodelid = isset($row['accountmovementmodelid']) ? $row['accountmovementmodelid'] : '';
        $accountmovement->accountmovementdate = isset($row['accountmovementdate']) ? $row['accountmovementdate'] : '';
        $accountmovement->userid = isset($row['userid']) ? $row['userid'] : '';
        $accountmovement->accountid = isset($row['accountid']) ? $row['accountid'] : '';
        $accountmovement->tablename = isset($row['tablename']) ? $row['tablename'] : '';
        $accountmovement->bankid = isset($row['bankid']) ? $row['bankid'] : '';
        $accountmovement->accountmovementcomment = isset($row['accountmovementcomment']) ? $row['accountmovementcomment'] : '';
        $accountmovement->accountmovementkindid = isset($row['accountmovementkindid']) ? $row['accountmovementkindid'] : '';
        $accountmovement->clientdebtchangeidfk = isset($row['clientdebtchangeidfk']) ? $row['clientdebtchangeidfk'] : '';
        $accountmovement->clientid = isset($row['clientid']) ? $row['clientid'] : '';


        $accountmovement->bankname = isset($row['bankname']) ? $row['bankname'] : '';
        $accountmovement->accountname = isset($row['accountname']) ? $row['accountname'] : '';
        $accountmovement->accountnumber = isset($row['accountnumber']) ? $row['accountnumber'] : '';
        $accountmovement->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $accountmovement->employeename = isset($row['employeename']) ? $row['employeename'] : '';
        $accountmovement->clientName = isset($row['clientName']) ? $row['clientName'] : '';

        return $accountmovement;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return AccountmovementMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>