<?php
/**
 * Class that operate on table 'billprinter'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2025-07-22 12:34
 */
class BillprinterMySqlDAO implements BillprinterDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return BillprinterMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM billprinter WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM billprinter';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM billprinter ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param billprinter primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM billprinter WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param BillprinterMySql billprinter
 	 */
	public function insert($billprinter){
		$sql = 'INSERT INTO billprinter (name, cats, userids, userid, sysdate, del) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($billprinter->name);
		$sqlQuery->set($billprinter->cats);
		$sqlQuery->set($billprinter->userids);
		$sqlQuery->setNumber($billprinter->userid);
		$sqlQuery->set($billprinter->sysdate);
		$sqlQuery->setNumber($billprinter->del);

		$id = $this->executeInsert($sqlQuery);	
		$billprinter->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param BillprinterMySql billprinter
 	 */
	public function update($billprinter){
		$sql = 'UPDATE billprinter SET name = ?, cats = ?, userids = ?, userid = ?, sysdate = ?, del = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($billprinter->name);
		$sqlQuery->set($billprinter->cats);
		$sqlQuery->set($billprinter->userids);
		$sqlQuery->setNumber($billprinter->userid);
		$sqlQuery->set($billprinter->sysdate);
		$sqlQuery->setNumber($billprinter->del);

		$sqlQuery->setNumber($billprinter->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM billprinter';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByName($value){
		$sql = 'SELECT * FROM billprinter WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCats($value){
		$sql = 'SELECT * FROM billprinter WHERE cats = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserids($value){
		$sql = 'SELECT * FROM billprinter WHERE userids = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM billprinter WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM billprinter WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM billprinter WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByName($value){
		$sql = 'DELETE FROM billprinter WHERE name = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCats($value){
		$sql = 'DELETE FROM billprinter WHERE cats = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserids($value){
		$sql = 'DELETE FROM billprinter WHERE userids = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM billprinter WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM billprinter WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM billprinter WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return BillprinterMySql 
	 */
	protected function readRow($row){
		$billprinter = new Billprinter();
		
		$billprinter->id = $row['id'];
		$billprinter->name = $row['name'];
		$billprinter->cats = $row['cats'];
		$billprinter->userids = $row['userids'];
		$billprinter->userid = $row['userid'];
		$billprinter->sysdate = $row['sysdate'];
		$billprinter->del = $row['del'];

		return $billprinter;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return BillprinterMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>