<?php
/**
 * Class that operate on table 'boarding'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2025-07-07 19:04
 */
class BoardingMySqlDAO implements BoardingDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return BoardingMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM boarding WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM boarding';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM boarding ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param boarding primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM boarding WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param BoardingMySql boarding
 	 */
	public function insert($boarding){
		$sql = 'INSERT INTO boarding (title, titleEn, titleUrl, openTarget, image, content, contentEn, position, isActive, sysDate, userid, isdel) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($boarding->title);
		$sqlQuery->set($boarding->titleEn);
		$sqlQuery->set($boarding->titleUrl);
		$sqlQuery->setNumber($boarding->openTarget);
		$sqlQuery->set($boarding->image);
		$sqlQuery->setString2($boarding->content);
		$sqlQuery->setString2($boarding->contentEn);
		$sqlQuery->setNumber($boarding->position);
		$sqlQuery->setNumber($boarding->isActive);
		$sqlQuery->set($boarding->sysDate);
		$sqlQuery->setNumber($boarding->userid);
		$sqlQuery->setNumber($boarding->isdel);

		$id = $this->executeInsert($sqlQuery);	
		$boarding->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param BoardingMySql boarding
 	 */
	public function update($boarding){
		$sql = 'UPDATE boarding SET title = ?, titleEn = ?, titleUrl = ?, openTarget = ?, image = ?, content = ?, contentEn = ?, position = ?, isActive = ?, sysDate = ?, userid = ?, isdel = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($boarding->title);
		$sqlQuery->set($boarding->titleEn);
		$sqlQuery->set($boarding->titleUrl);
		$sqlQuery->setNumber($boarding->openTarget);
		$sqlQuery->set($boarding->image);
		$sqlQuery->setString2($boarding->content);
		$sqlQuery->setString2($boarding->contentEn);
		$sqlQuery->setNumber($boarding->position);
		$sqlQuery->setNumber($boarding->isActive);
		$sqlQuery->set($boarding->sysDate);
		$sqlQuery->setNumber($boarding->userid);
		$sqlQuery->setNumber($boarding->isdel);

		$sqlQuery->setNumber($boarding->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM boarding';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTitle($value){
		$sql = 'SELECT * FROM boarding WHERE title = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTitleEn($value){
		$sql = 'SELECT * FROM boarding WHERE titleEn = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTitleUrl($value){
		$sql = 'SELECT * FROM boarding WHERE titleUrl = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByOpenTarget($value){
		$sql = 'SELECT * FROM boarding WHERE openTarget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByImage($value){
		$sql = 'SELECT * FROM boarding WHERE image = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByContent($value){
		$sql = 'SELECT * FROM boarding WHERE content = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByContentEn($value){
		$sql = 'SELECT * FROM boarding WHERE contentEn = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPosition($value){
		$sql = 'SELECT * FROM boarding WHERE position = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByIsActive($value){
		$sql = 'SELECT * FROM boarding WHERE isActive = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysDate($value){
		$sql = 'SELECT * FROM boarding WHERE sysDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM boarding WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByIsdel($value){
		$sql = 'SELECT * FROM boarding WHERE isdel = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTitle($value){
		$sql = 'DELETE FROM boarding WHERE title = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTitleEn($value){
		$sql = 'DELETE FROM boarding WHERE titleEn = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTitleUrl($value){
		$sql = 'DELETE FROM boarding WHERE titleUrl = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByOpenTarget($value){
		$sql = 'DELETE FROM boarding WHERE openTarget = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByImage($value){
		$sql = 'DELETE FROM boarding WHERE image = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByContent($value){
		$sql = 'DELETE FROM boarding WHERE content = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByContentEn($value){
		$sql = 'DELETE FROM boarding WHERE contentEn = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPosition($value){
		$sql = 'DELETE FROM boarding WHERE position = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByIsActive($value){
		$sql = 'DELETE FROM boarding WHERE isActive = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysDate($value){
		$sql = 'DELETE FROM boarding WHERE sysDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM boarding WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByIsdel($value){
		$sql = 'DELETE FROM boarding WHERE isdel = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return BoardingMySql 
	 */
	protected function readRow($row){
		$boarding = new Boarding();
		
		$boarding->id = $row['id'];
		$boarding->title = $row['title'];
		$boarding->titleEn = $row['titleEn'];
		$boarding->titleUrl = $row['titleUrl'];
		$boarding->openTarget = $row['openTarget'];
		$boarding->image = $row['image'];
		$boarding->content = $row['content'];
		$boarding->contentEn = $row['contentEn'];
		$boarding->position = $row['position'];
		$boarding->isActive = $row['isActive'];
		$boarding->sysDate = $row['sysDate'];
		$boarding->userid = $row['userid'];
		$boarding->isdel = $row['isdel'];

		return $boarding;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return BoardingMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>