<?php
/**
 * Class that operate on table 'buypriceshistorybook'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-09-29 22:15
 */
class BuypriceshistorybookMySqlDAO implements BuypriceshistorybookDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return BuypriceshistorybookMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM buypriceshistorybook';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM buypriceshistorybook ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param buypriceshistorybook primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM buypriceshistorybook WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param BuypriceshistorybookMySql buypriceshistorybook
 	 */
	public function insert($buypriceshistorybook){
		$sql = 'INSERT INTO buypriceshistorybook (theDate, storeId, productid, sizeid, colorid, buyprice, buyQuantity, sellQuantity, del, userid, sysDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($buypriceshistorybook->theDate);
		$sqlQuery->setNumber($buypriceshistorybook->storeId);
		$sqlQuery->setNumber($buypriceshistorybook->productid);
		$sqlQuery->setNumber($buypriceshistorybook->sizeid);
		$sqlQuery->setNumber($buypriceshistorybook->colorid);
		$sqlQuery->set($buypriceshistorybook->buyprice);
		$sqlQuery->set($buypriceshistorybook->buyQuantity);
		$sqlQuery->set($buypriceshistorybook->sellQuantity);
		$sqlQuery->setNumber($buypriceshistorybook->del);
		$sqlQuery->setNumber($buypriceshistorybook->userid);
		$sqlQuery->set($buypriceshistorybook->sysDate);

		$id = $this->executeInsert($sqlQuery);	
		$buypriceshistorybook->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param BuypriceshistorybookMySql buypriceshistorybook
 	 */
	public function update($buypriceshistorybook){
		$sql = 'UPDATE buypriceshistorybook SET theDate = ?, storeId = ?, productid = ?, sizeid = ?, colorid = ?, buyprice = ?, buyQuantity = ?, sellQuantity = ?, del = ?, userid = ?, sysDate = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($buypriceshistorybook->theDate);
		$sqlQuery->setNumber($buypriceshistorybook->storeId);
		$sqlQuery->setNumber($buypriceshistorybook->productid);
		$sqlQuery->setNumber($buypriceshistorybook->sizeid);
		$sqlQuery->setNumber($buypriceshistorybook->colorid);
		$sqlQuery->set($buypriceshistorybook->buyprice);
		$sqlQuery->set($buypriceshistorybook->buyQuantity);
		$sqlQuery->set($buypriceshistorybook->sellQuantity);
		$sqlQuery->setNumber($buypriceshistorybook->del);
		$sqlQuery->setNumber($buypriceshistorybook->userid);
		$sqlQuery->set($buypriceshistorybook->sysDate);

		$sqlQuery->setNumber($buypriceshistorybook->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM buypriceshistorybook';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTheDate($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE theDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStoreId($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE storeId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByProductid($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySizeid($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE sizeid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByColorid($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE colorid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBuyprice($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE buyprice = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByBuyQuantity($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE buyQuantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellQuantity($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE sellQuantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDel($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysDate($value){
		$sql = 'SELECT * FROM buypriceshistorybook WHERE sysDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTheDate($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE theDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStoreId($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE storeId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByProductid($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySizeid($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE sizeid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByColorid($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE colorid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBuyprice($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE buyprice = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByBuyQuantity($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE buyQuantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellQuantity($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE sellQuantity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDel($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE del = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysDate($value){
		$sql = 'DELETE FROM buypriceshistorybook WHERE sysDate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return BuypriceshistorybookMySql 
	 */
	protected function readRow($row){
		$buypriceshistorybook = new Buypriceshistorybook();
		
		$buypriceshistorybook->id = $row['id'];
		$buypriceshistorybook->theDate = $row['theDate'];
		$buypriceshistorybook->storeId = $row['storeId'];
		$buypriceshistorybook->productid = $row['productid'];
		$buypriceshistorybook->sizeid = $row['sizeid'];
		$buypriceshistorybook->colorid = $row['colorid'];
		$buypriceshistorybook->buyprice = $row['buyprice'];
		$buypriceshistorybook->buyQuantity = $row['buyQuantity'];
		$buypriceshistorybook->sellQuantity = $row['sellQuantity'];
		$buypriceshistorybook->del = $row['del'];
		$buypriceshistorybook->userid = $row['userid'];
		$buypriceshistorybook->sysDate = $row['sysDate'];

		return $buypriceshistorybook;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return BuypriceshistorybookMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>