<?php

/**
 * Class that operate on table 'checkdeposit'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class CheckdepositMySqlDAO implements CheckdepositDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return CheckdepositMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM checkdeposit WHERE checkdepositid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM checkdeposit';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM checkdeposit ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param checkdeposit primary key
     */
    public function delete($checkdepositid) {
        $sql = 'DELETE FROM checkdeposit WHERE checkdepositid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($checkdepositid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param CheckdepositMySql checkdeposit
     */
    public function insert($checkdeposit, $note) {
        $sql = 'INSERT INTO checkdeposit (bankaccountid, clientid, checkdepositnumber, checkdeposituser, checkdepositamount, checkdepositdate, checkdepositnote, userid, conditions, accountbeforevalue,dailyentryid , checkdate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($checkdeposit->bankaccountid);
        $sqlQuery->setNumber($checkdeposit->clientid);
        $sqlQuery->setNumber((int)$checkdeposit->checkdepositnumber);
        $sqlQuery->set($checkdeposit->checkdeposituser);
        $sqlQuery->set($checkdeposit->checkdepositamount);
        $sqlQuery->set($checkdeposit->checkdepositdate);
        $sqlQuery->setString2($note);
        $sqlQuery->setNumber($checkdeposit->userid);
        $sqlQuery->setNumber($checkdeposit->conditions);
        $sqlQuery->set($checkdeposit->accountbeforevalue);
        $sqlQuery->setNumber($checkdeposit->dailyentryid);

        //# tarek
        $sqlQuery->set($checkdeposit->checkdate);

        $id = $this->executeInsert($sqlQuery);
        $checkdeposit->checkdepositid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param CheckdepositMySql checkdeposit
     */
    public function update($checkdeposit, $note) {
        $sql = 'UPDATE checkdeposit SET bankaccountid = ?, clientid = ?, checkdepositnumber = ?, checkdeposituser = ?, checkdepositamount = ?, checkdepositdate = ?, checkdepositnote = ?, userid = ?, conditions = ?, accountbeforevalue = ?,dailyentryid=? , checkdate=? WHERE checkdepositid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($checkdeposit->bankaccountid);
        $sqlQuery->setNumber($checkdeposit->clientid);
        $sqlQuery->setNumber((int)$checkdeposit->checkdepositnumber);
        $sqlQuery->set($checkdeposit->checkdeposituser);
        $sqlQuery->set($checkdeposit->checkdepositamount);
        $sqlQuery->set($checkdeposit->checkdepositdate);
        $sqlQuery->setString2($note);
        $sqlQuery->setNumber($checkdeposit->userid);
        $sqlQuery->setNumber($checkdeposit->conditions);
        $sqlQuery->set($checkdeposit->accountbeforevalue);
        $sqlQuery->setNumber($checkdeposit->dailyentryid);

        //# tarek
        $sqlQuery->set($checkdeposit->checkdate);

        $sqlQuery->setNumber($checkdeposit->checkdepositid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM checkdeposit';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBankaccountid($value) {
        $sql = 'SELECT * FROM checkdeposit WHERE bankaccountid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM checkdeposit WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckdepositnumber($value) {
        $sql = 'SELECT * FROM checkdeposit WHERE checkdepositnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckdeposituser($value) {
        $sql = 'SELECT * FROM checkdeposit WHERE checkdeposituser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckdepositamount($value) {
        $sql = 'SELECT * FROM checkdeposit WHERE checkdepositamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckdepositdate($value) {
        $sql = 'SELECT * FROM checkdeposit WHERE checkdepositdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckdepositnote($value) {
        $sql = 'SELECT * FROM checkdeposit WHERE checkdepositnote = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM checkdeposit WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM checkdeposit WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountbeforevalue($value) {
        $sql = 'SELECT * FROM checkdeposit WHERE accountbeforevalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBankaccountid($value) {
        $sql = 'DELETE FROM checkdeposit WHERE bankaccountid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM checkdeposit WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckdepositnumber($value) {
        $sql = 'DELETE FROM checkdeposit WHERE checkdepositnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckdeposituser($value) {
        $sql = 'DELETE FROM checkdeposit WHERE checkdeposituser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckdepositamount($value) {
        $sql = 'DELETE FROM checkdeposit WHERE checkdepositamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckdepositdate($value) {
        $sql = 'DELETE FROM checkdeposit WHERE checkdepositdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckdepositnote($value) {
        $sql = 'DELETE FROM checkdeposit WHERE checkdepositnote = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM checkdeposit WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM checkdeposit WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountbeforevalue($value) {
        $sql = 'DELETE FROM checkdeposit WHERE accountbeforevalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return CheckdepositMySql
     */
    protected function readRow($row) {
        $checkdeposit = new Checkdeposit();

        $checkdeposit->checkdepositid = isset($row['checkdepositid']) ? $row['checkdepositid'] : '';
        $checkdeposit->bankaccountid = isset($row['bankaccountid']) ? $row['bankaccountid'] : '';
        $checkdeposit->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $checkdeposit->checkdepositnumber = isset($row['checkdepositnumber']) ? $row['checkdepositnumber'] : '';
        $checkdeposit->checkdeposituser = isset($row['checkdeposituser']) ? $row['checkdeposituser'] : '';
        $checkdeposit->checkdepositamount = isset($row['checkdepositamount']) ? $row['checkdepositamount'] : '';
        $checkdeposit->checkdepositdate = isset($row['checkdepositdate']) ? $row['checkdepositdate'] : '';
        $checkdeposit->checkdepositnote = isset($row['checkdepositnote']) ? $row['checkdepositnote'] : '';
        $checkdeposit->userid = isset($row['userid']) ? $row['userid'] : '';
        $checkdeposit->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $checkdeposit->accountbeforevalue = isset($row['accountbeforevalue']) ? $row['accountbeforevalue'] : '';

        $checkdeposit->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $checkdeposit->accountname = isset($row['accountname']) ? $row['accountname'] : '';
        $checkdeposit->bankname = isset($row['bankname']) ? $row['bankname'] : '';
        $checkdeposit->accountbeginingbalance = isset($row['accountbeginingbalance']) ? $row['accountbeginingbalance'] : '';
        $checkdeposit->accountnumber = isset($row['accountnumber']) ? $row['accountnumber'] : '';
        $checkdeposit->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $checkdeposit->checkdate = isset($row['checkdate']) ? $row['checkdate'] : '';





        return $checkdeposit;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return CheckdepositMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>