<?php

/**
 * Class that operate on table 'checkwithdrawal'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class CheckwithdrawalMySqlDAO implements CheckwithdrawalDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return CheckwithdrawalMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE checkwithdrawalid = ?';


        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM checkwithdrawal';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM checkwithdrawal ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param checkwithdrawal primary key
     */
    public function delete($checkwithdrawalid) {
        $sql = 'DELETE FROM checkwithdrawal WHERE checkwithdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($checkwithdrawalid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param CheckwithdrawalMySql checkwithdrawal
     */
    public function insert($checkwithdrawal, $checkwithdrawalnote) {
        $sql = 'INSERT INTO checkwithdrawal (bankaccountid, supplierid, accountbeforevalue, checkwithdrawaluser, checkwithdrawalamount, checkwithdrawaldate, checkwithdrawalnote, userid, conditions, checkwithdrawalnumber,dailyentryid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($checkwithdrawal->bankaccountid);
        $sqlQuery->setNumber($checkwithdrawal->supplierid);
        $sqlQuery->set($checkwithdrawal->accountbeforevalue);
        $sqlQuery->set($checkwithdrawal->checkwithdrawaluser);
        $sqlQuery->set($checkwithdrawal->checkwithdrawalamount);
        $sqlQuery->set($checkwithdrawal->checkwithdrawaldate);
        $sqlQuery->setString2($checkwithdrawal->checkwithdrawalnote);
        $sqlQuery->setNumber($checkwithdrawal->userid);
        $sqlQuery->setNumber($checkwithdrawal->conditions);
        $sqlQuery->set($checkwithdrawal->checkwithdrawalnumber);
        $sqlQuery->setNumber($checkwithdrawal->dailyentryid);

        $id = $this->executeInsert($sqlQuery);

        //print_r("id = ".$id);
        $checkwithdrawal->checkwithdrawalid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param CheckwithdrawalMySql checkwithdrawal
     */
    public function update($checkwithdrawal) {
        $sql = 'UPDATE checkwithdrawal SET bankaccountid = ?, supplierid = ?, accountbeforevalue = ?, checkwithdrawaluser = ?, checkwithdrawalamount = ?, checkwithdrawaldate = ?, checkwithdrawalnote = ?, userid = ?, conditions = ?, checkwithdrawalnumber = ? , dailyentryid=? WHERE checkwithdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($checkwithdrawal->bankaccountid);
        $sqlQuery->setNumber($checkwithdrawal->supplierid);
        $sqlQuery->set($checkwithdrawal->accountbeforevalue);
        $sqlQuery->set($checkwithdrawal->checkwithdrawaluser);
        $sqlQuery->set($checkwithdrawal->checkwithdrawalamount);
        $sqlQuery->set($checkwithdrawal->checkwithdrawaldate);
        $sqlQuery->set($checkwithdrawal->checkwithdrawalnote);
        $sqlQuery->setNumber($checkwithdrawal->userid);
        $sqlQuery->setNumber($checkwithdrawal->conditions);
        $sqlQuery->set($checkwithdrawal->checkwithdrawalnumber);
        $sqlQuery->setNumber($checkwithdrawal->dailyentryid);

        $sqlQuery->setNumber($checkwithdrawal->checkwithdrawalid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM checkwithdrawal';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBankaccountid($value) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE bankaccountid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierid($value) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountbeforevalue($value) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE accountbeforevalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckwithdrawaluser($value) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE checkwithdrawaluser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckwithdrawalamount($value) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE checkwithdrawalamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckwithdrawaldate($value) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE checkwithdrawaldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckwithdrawalnote($value) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE checkwithdrawalnote = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCheckwithdrawalnumber($value) {
        $sql = 'SELECT * FROM checkwithdrawal WHERE checkwithdrawalnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBankaccountid($value) {
        $sql = 'DELETE FROM checkwithdrawal WHERE bankaccountid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierid($value) {
        $sql = 'DELETE FROM checkwithdrawal WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountbeforevalue($value) {
        $sql = 'DELETE FROM checkwithdrawal WHERE accountbeforevalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckwithdrawaluser($value) {
        $sql = 'DELETE FROM checkwithdrawal WHERE checkwithdrawaluser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckwithdrawalamount($value) {
        $sql = 'DELETE FROM checkwithdrawal WHERE checkwithdrawalamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckwithdrawaldate($value) {
        $sql = 'DELETE FROM checkwithdrawal WHERE checkwithdrawaldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckwithdrawalnote($value) {
        $sql = 'DELETE FROM checkwithdrawal WHERE checkwithdrawalnote = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM checkwithdrawal WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM checkwithdrawal WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCheckwithdrawalnumber($value) {
        $sql = 'DELETE FROM checkwithdrawal WHERE checkwithdrawalnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return CheckwithdrawalMySql
     */
    protected function readRow($row) {
        $checkwithdrawal = new Checkwithdrawal();

        $checkwithdrawal->checkwithdrawalid = isset($row['checkwithdrawalid']) ? $row['checkwithdrawalid'] : '';
        $checkwithdrawal->bankaccountid = isset($row['bankaccountid']) ? $row['bankaccountid'] : '';
        $checkwithdrawal->supplierid = isset($row['supplierid']) ? $row['supplierid'] : '';
        $checkwithdrawal->accountbeforevalue = isset($row['accountbeforevalue']) ? $row['accountbeforevalue'] : '';
        $checkwithdrawal->checkwithdrawaluser = isset($row['checkwithdrawaluser']) ? $row['checkwithdrawaluser'] : '';
        $checkwithdrawal->checkwithdrawalamount = isset($row['checkwithdrawalamount']) ? $row['checkwithdrawalamount'] : '';
        $checkwithdrawal->checkwithdrawaldate = isset($row['checkwithdrawaldate']) ? $row['checkwithdrawaldate'] : '';
        $checkwithdrawal->checkwithdrawalnote = isset($row['checkwithdrawalnote']) ? $row['checkwithdrawalnote'] : '';
        $checkwithdrawal->userid = isset($row['userid']) ? $row['userid'] : '';
        $checkwithdrawal->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $checkwithdrawal->checkwithdrawalnumber = isset($row['checkwithdrawalnumber']) ? $row['checkwithdrawalnumber'] : '';
        $checkwithdrawal->accountname = isset($row['accountname']) ? $row['accountname'] : '';
        $checkwithdrawal->bankname = isset($row['bankname']) ? $row['bankname'] : '';
        $checkwithdrawal->bankid = isset($row['bankid']) ? $row['bankid'] : '';
        $checkwithdrawal->accountnumber = isset($row['accountnumber']) ? $row['accountnumber'] : '';
        $checkwithdrawal->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';
        $checkwithdrawal->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';


        return $checkwithdrawal;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return CheckwithdrawalMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>