<?php

/**
 * Class that operate on table 'complementpurchasebillreturns'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class ComplementpurchasebillreturnsMySqlDAO implements ComplementpurchasebillreturnsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ComplementpurchasebillreturnsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM complementpurchasebillreturns WHERE complementpurchasebillreturnid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM complementpurchasebillreturns';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM complementpurchasebillreturns ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param complementpurchasebillreturn primary key
     */
    public function delete($complementpurchasebillreturnid) {
        $sql = 'DELETE FROM complementpurchasebillreturns WHERE complementpurchasebillreturnid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($complementpurchasebillreturnid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ComplementpurchasebillreturnsMySql complementpurchasebillreturn
     */
    public function insert($complementpurchasebillreturn) {
        $sql = 'INSERT INTO complementpurchasebillreturns (rawmaterialid, rawmaterialprice, rawmaterialamount, rawmaterialdisount, complementpurchasebillreturntotal) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($complementpurchasebillreturn->rawmaterialid);
        $sqlQuery->set($complementpurchasebillreturn->rawmaterialprice);
        $sqlQuery->set($complementpurchasebillreturn->rawmaterialamount);
        $sqlQuery->set($complementpurchasebillreturn->rawmaterialdisount);
        $sqlQuery->set($complementpurchasebillreturn->complementpurchasebillreturntotal);

        $id = $this->executeInsert($sqlQuery);
        $complementpurchasebillreturn->complementpurchasebillreturnid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ComplementpurchasebillreturnsMySql complementpurchasebillreturn
     */
    public function update($complementpurchasebillreturn) {
        $sql = 'UPDATE complementpurchasebillreturns SET rawmaterialid = ?, rawmaterialprice = ?, rawmaterialamount = ?, rawmaterialdisount = ?, complementpurchasebillreturntotal = ? WHERE complementpurchasebillreturnid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($complementpurchasebillreturn->rawmaterialid);
        $sqlQuery->set($complementpurchasebillreturn->rawmaterialprice);
        $sqlQuery->set($complementpurchasebillreturn->rawmaterialamount);
        $sqlQuery->set($complementpurchasebillreturn->rawmaterialdisount);
        $sqlQuery->set($complementpurchasebillreturn->complementpurchasebillreturntotal);

        $sqlQuery->setNumber($complementpurchasebillreturn->complementpurchasebillreturnid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM complementpurchasebillreturns';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRawmaterialid($value) {
        $sql = 'SELECT * FROM complementpurchasebillreturns WHERE rawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialprice($value) {
        $sql = 'SELECT * FROM complementpurchasebillreturns WHERE rawmaterialprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialamount($value) {
        $sql = 'SELECT * FROM complementpurchasebillreturns WHERE rawmaterialamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialdisount($value) {
        $sql = 'SELECT * FROM complementpurchasebillreturns WHERE rawmaterialdisount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComplementpurchasebillreturntotal($value) {
        $sql = 'SELECT * FROM complementpurchasebillreturns WHERE complementpurchasebillreturntotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRawmaterialid($value) {
        $sql = 'DELETE FROM complementpurchasebillreturns WHERE rawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialprice($value) {
        $sql = 'DELETE FROM complementpurchasebillreturns WHERE rawmaterialprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialamount($value) {
        $sql = 'DELETE FROM complementpurchasebillreturns WHERE rawmaterialamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialdisount($value) {
        $sql = 'DELETE FROM complementpurchasebillreturns WHERE rawmaterialdisount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComplementpurchasebillreturntotal($value) {
        $sql = 'DELETE FROM complementpurchasebillreturns WHERE complementpurchasebillreturntotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ComplementpurchasebillreturnsMySql
     */
    protected function readRow($row) {
        $complementpurchasebillreturn = new Complementpurchasebillreturn();

        $complementpurchasebillreturn->complementpurchasebillreturnid = isset($row['complementpurchasebillreturnid']) ? $row['complementpurchasebillreturnid'] : '';
        $complementpurchasebillreturn->rawmaterialid = isset($row['rawmaterialid']) ? $row['rawmaterialid'] : '';
        $complementpurchasebillreturn->rawmaterialprice = isset($row['rawmaterialprice']) ? $row['rawmaterialprice'] : '';
        $complementpurchasebillreturn->rawmaterialamount = isset($row['rawmaterialamount']) ? $row['rawmaterialamount'] : '';
        $complementpurchasebillreturn->rawmaterialdisount = isset($row['rawmaterialdisount']) ? $row['rawmaterialdisount'] : '';
        $complementpurchasebillreturn->complementpurchasebillreturntotal = isset($row['complementpurchasebillreturntotal']) ? $row['complementpurchasebillreturntotal'] : '';

        return $complementpurchasebillreturn;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ComplementpurchasebillreturnsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>