<?php

/**
 * Class that operate on table 'dailyentry'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-04-18 15:43
 */
class DailyentryMySqlDAO implements DailyentryDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return DailyentryMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM dailyentry WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM dailyentry';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM dailyentry ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param dailyentry primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM dailyentry WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param DailyentryMySql dailyentry
     */
    public function insert($dailyentry) {
        $sql = 'INSERT INTO dailyentry (totalcreditor, totaldebtor, thedate, userid, `condition`, reverseofid, dDateTime,entryComment,fromFlag,related,branchid,isopeningentry,operationId,operationDetailLink) VALUES ( ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($dailyentry->totalcreditor);
        $sqlQuery->set($dailyentry->totaldebtor);
        $sqlQuery->set($dailyentry->thedate);
        $sqlQuery->setNumber($dailyentry->userid);
        $sqlQuery->setNumber($dailyentry->condition);
        $sqlQuery->setNumber($dailyentry->reverseofid);
        $sqlQuery->set($dailyentry->dDateTime);
        $sqlQuery->set($dailyentry->entryComment);
        $sqlQuery->setNumber($dailyentry->fromFlag);
        $sqlQuery->setNumber($dailyentry->related);
        $sqlQuery->setNumber($dailyentry->branchid);
        $sqlQuery->setNumber((int) $dailyentry->isopeningentry);
        $sqlQuery->setNumber((int) $dailyentry->operationId);
        $sqlQuery->set($dailyentry->operationDetailLink);



        $id = $this->executeInsert($sqlQuery);
        $dailyentry->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param DailyentryMySql dailyentry
     */
    public function update($dailyentry) {
        $sql = 'UPDATE dailyentry SET totalcreditor = ?, totaldebtor = ?, thedate = ?, userid = ?, `condition` = ?, reverseofid = ?, dDateTime = ?, entryComment = ?, fromFlag = ?,related=?,isopeningentry=?,operationId=?,operationDetailLink=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($dailyentry->totalcreditor);
        $sqlQuery->set($dailyentry->totaldebtor);
        $sqlQuery->set($dailyentry->thedate);
        $sqlQuery->setNumber($dailyentry->userid);
        $sqlQuery->setNumber($dailyentry->condition);
        $sqlQuery->setNumber($dailyentry->reverseofid);
        $sqlQuery->set($dailyentry->dDateTime);
        $sqlQuery->set($dailyentry->entryComment);
        $sqlQuery->setNumber($dailyentry->fromFlag);
        $sqlQuery->setNumber($dailyentry->related);
        $sqlQuery->setNumber((int) $dailyentry->isopeningentry);
        $sqlQuery->setNumber((int) $dailyentry->operationId);
        $sqlQuery->set($dailyentry->operationDetailLink);

        $sqlQuery->setNumber($dailyentry->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM dailyentry';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByTotalcreditor($value) {
        $sql = 'SELECT * FROM dailyentry WHERE totalcreditor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotaldebtor($value) {
        $sql = 'SELECT * FROM dailyentry WHERE totaldebtor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByThedate($value) {
        $sql = 'SELECT * FROM dailyentry WHERE thedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM dailyentry WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM dailyentry WHERE `condition` = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReverseofid($value) {
        $sql = 'SELECT * FROM dailyentry WHERE reverseofid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDDateTime($value) {
        $sql = 'SELECT * FROM dailyentry WHERE dDateTime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCostcenterid($value) {
        $sql = 'SELECT * FROM dailyentry WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByTotalcreditor($value) {
        $sql = 'DELETE FROM dailyentry WHERE totalcreditor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotaldebtor($value) {
        $sql = 'DELETE FROM dailyentry WHERE totaldebtor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByThedate($value) {
        $sql = 'DELETE FROM dailyentry WHERE thedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM dailyentry WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM dailyentry WHERE `condition` = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReverseofid($value) {
        $sql = 'DELETE FROM dailyentry WHERE reverseofid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDDateTime($value) {
        $sql = 'DELETE FROM dailyentry WHERE dDateTime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCostcenterid($value) {
        $sql = 'DELETE FROM dailyentry WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return DailyentryMySql
     */
    protected function readRow($row) {
        $dailyentry = new Dailyentry();

        $dailyentry->id = isset($row['id']) ? $row['id'] : '';
        $dailyentry->totalcreditor = isset($row['totalcreditor']) ? $row['totalcreditor'] : '';
        $dailyentry->totaldebtor = isset($row['totaldebtor']) ? $row['totaldebtor'] : '';
        $dailyentry->thedate = isset($row['thedate']) ? $row['thedate'] : '';
        $dailyentry->userid = isset($row['userid']) ? $row['userid'] : '';
        $dailyentry->condition = isset($row['condition']) ? $row['condition'] : '';
        $dailyentry->reverseofid = isset($row['reverseofid']) ? $row['reverseofid'] : '';
        $dailyentry->dDateTime = isset($row['dDateTime']) ? $row['dDateTime'] : '';
        //$dailyentry->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';[''];
        $dailyentry->entryComment = isset($row['entryComment']) ? $row['entryComment'] : '';
        $dailyentry->fromFlag = isset($row['fromFlag']) ? $row['fromFlag'] : '';
        $dailyentry->related = isset($row['related']) ? $row['related'] : '';
        $dailyentry->isopeningentry = isset($row['isopeningentry']) ? $row['isopeningentry'] : '';
        $dailyentry->branchid = isset($row['branchid']) ? $row['branchid'] : '';
        $dailyentry->operationId = isset($row['operationId']) ? $row['operationId'] : '';
        $dailyentry->operationDetailLink = isset($row['operationDetailLink']) ? $row['operationDetailLink'] : '';


        //
        $dailyentry->from = isset($row['from']) ? $row['from'] : '';
        $dailyentry->to = isset($row['to']) ? $row['to'] : '';
        //
        $dailyentry->idChild = isset($row['idChild']) ? $row['idChild'] : '';
        $dailyentry->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $dailyentry->accountstreeid = isset($row['accountstreeid']) ? $row['accountstreeid'] : '';
        $dailyentry->value = isset($row['value']) ? $row['value'] : '';
        $dailyentry->type = isset($row['type']) ? $row['type'] : '';
        $dailyentry->accountstreeName = isset($row['accountstreeName']) ? $row['accountstreeName'] : '';
        $dailyentry->dComment = isset($row['dComment']) ? $row['dComment'] : '';
        $dailyentry->branchName = isset($row['branchName']) ? $row['branchName'] : '';


        return $dailyentry;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return DailyentryMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>