<?php

/**
 * Class that operate on table 'employee'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-07-26 12:58
 */
class EmployeeMySqlDAO implements EmployeeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return EmployeeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM employee WHERE employeeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM employee';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM employee ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param employee primary key
     */
    public function delete($employeeId) {
        $sql = 'DELETE FROM employee WHERE employeeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($employeeId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param EmployeeMySql employee
     */
    public function insert($employee) {
        $sql = 'INSERT INTO employee (employeeName, employeeBOD, employeeAddress, employeePhone, employeeSalary, employeeBouns, employeeDate, conditions, userId, username, isworker, Hourlyrate, houseAllowance, transportationAllowance, otherAllowance, nationality, religion, noOfWorkDaysPerMonth, noOfWorkHoursDaysPerDay, noOfDistountDaysWhenAbsences, contract, residence, personalPhoto, healthCard, visa, passport, minuteLateCost, dayAbsencesCost, graduate, expert1, expert2, expert3, employeegroupid, employeesubgroupid, halfHourLateWithPermissionDisount, hourLateWithPermissionDisount, hourAndHalfLateWithPermissionDisount, twoHoursLateWithPermissionDisount, halfHourLateWithoutPermissionDisount, hourLateWithoutPermissionDisount, hourAndHalfLateWithoutPermissionDisount, twoHoursLateWithoutPermissionDisount, halfHourPermissionDisount, hourPermissionDisount, hourAndHalfPermissionDisount, twoHoursPermissionDisount, dayAbsenceWithPermissionDisount, dayAbsenceWithoutPermissionDisount,moreThanTwoHoursLateWithPermissionDisount,moreThanTwoHoursLateWithoutPermissionDisount,empFingerId,empRFID,empFingerId2,empFingerId3,empFingerId4,empFingerId5,numberOfMinutesOfDelayAllowed,takeVacationDays,treeId,treeId2,quarterHourLateWithPermissionDisount,quarterHourLateWithoutPermissionDisount, numberOfCountsOfDelayAllowed,branchid,empCode,socialInsurance,workTax,sysdate,birthCertificate,armyPhoto,idCard,driverLicense,endorsementPeace,confidentialityDeclaration,criminalCamouflage,practiceProfession,socialStatus,administration,worthExtra,subManagement,directManager,occupation,dateBeing,gender,socialSituation,bankAccount,dcholarship,extradayval) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($employee->employeeName);
        $sqlQuery->set($employee->employeeBOD);
        $sqlQuery->setString2($employee->employeeAddress);
        $sqlQuery->set($employee->employeePhone);
        $sqlQuery->set($employee->employeeSalary);
        $sqlQuery->set($employee->employeeBouns);
        $sqlQuery->set($employee->employeeDate);
        $sqlQuery->setNumber($employee->conditions);
        $sqlQuery->setNumber($employee->userId);
        $sqlQuery->set($employee->username);
        $sqlQuery->setNumber($employee->isworker);
        $sqlQuery->set($employee->hourlyrate);
        $sqlQuery->set($employee->houseAllowance);
        $sqlQuery->set($employee->transportationAllowance);
        $sqlQuery->set($employee->otherAllowance);
        $sqlQuery->set($employee->nationality);
        $sqlQuery->set($employee->religion);
        $sqlQuery->setNumber($employee->noOfWorkDaysPerMonth);
        $sqlQuery->setNumber($employee->noOfWorkHoursDaysPerDay);
        $sqlQuery->setNumber($employee->noOfDistountDaysWhenAbsences);
        $sqlQuery->set($employee->contract);
        $sqlQuery->set($employee->residence);
        $sqlQuery->set($employee->personalPhoto);
        $sqlQuery->set($employee->healthCard);
        $sqlQuery->set($employee->visa);
        $sqlQuery->set($employee->passport);
        $sqlQuery->set($employee->minuteLateCost);
        $sqlQuery->set($employee->dayAbsencesCost);
        $sqlQuery->set($employee->graduate);
        $sqlQuery->set($employee->expert1);
        $sqlQuery->set($employee->expert2);
        $sqlQuery->set($employee->expert3);
        $sqlQuery->set($employee->employeegroupid);
        $sqlQuery->set($employee->employeesubgroupid);
        $sqlQuery->set($employee->halfHourLateWithPermissionDisount);
        $sqlQuery->set($employee->hourLateWithPermissionDisount);
        $sqlQuery->set($employee->hourAndHalfLateWithPermissionDisount);
        $sqlQuery->set($employee->twoHoursLateWithPermissionDisount);
        $sqlQuery->set($employee->halfHourLateWithoutPermissionDisount);
        $sqlQuery->set($employee->hourLateWithoutPermissionDisount);
        $sqlQuery->set($employee->hourAndHalfLateWithoutPermissionDisount);
        $sqlQuery->set($employee->twoHoursLateWithoutPermissionDisount);
        $sqlQuery->set($employee->halfHourPermissionDisount);
        $sqlQuery->set($employee->hourPermissionDisount);
        $sqlQuery->set($employee->hourAndHalfPermissionDisount);
        $sqlQuery->set($employee->twoHoursPermissionDisount);
        $sqlQuery->set($employee->dayAbsenceWithPermissionDisount);
        $sqlQuery->set($employee->dayAbsenceWithoutPermissionDisount);
        $sqlQuery->set($employee->moreThanTwoHoursLateWithPermissionDisount);
        $sqlQuery->set($employee->moreThanTwoHoursLateWithoutPermissionDisount);
        $sqlQuery->set($employee->empFingerId);
        $sqlQuery->set($employee->empRFID);
        $sqlQuery->set($employee->empFingerId2);
        $sqlQuery->set($employee->empFingerId3);
        $sqlQuery->set($employee->empFingerId4);
        $sqlQuery->set($employee->empFingerId5);
        $sqlQuery->setNumber($employee->numberOfMinutesOfDelayAllowed);
        $sqlQuery->setNumber($employee->takeVacationDays);
        $sqlQuery->setNumber((int) $employee->treeId);
        $sqlQuery->setNumber((int) $employee->treeId2);
        $sqlQuery->set($employee->quarterHourLateWithPermissionDisount);
        $sqlQuery->set($employee->quarterHourLateWithoutPermissionDisount);
        $sqlQuery->setNumber((int) $employee->numberOfCountsOfDelayAllowed);
        $sqlQuery->setNumber($employee->branchid);
        $sqlQuery->setNumber($employee->empCode);
        $sqlQuery->setNumber((float) $employee->socialInsurance);
        $sqlQuery->setNumber((float) $employee->workTax);
        $sqlQuery->set($employee->sysdate);
        $sqlQuery->set($employee->birthCertificate);
        $sqlQuery->set($employee->armyPhoto);
        $sqlQuery->set($employee->idCard);
        $sqlQuery->set($employee->driverLicense);
        $sqlQuery->set($employee->endorsementPeace);
        $sqlQuery->set($employee->confidentialityDeclaration);
        $sqlQuery->set($employee->criminalCamouflage);
        $sqlQuery->set($employee->practiceProfession);
        $sqlQuery->set($employee->socialStatus);
        $sqlQuery->set($employee->administration);
        $sqlQuery->set($employee->worthExtra);
        $sqlQuery->set($employee->subManagement);
        $sqlQuery->set($employee->directManager);
        $sqlQuery->set($employee->occupation);
        $sqlQuery->set($employee->dateBeing);
        $sqlQuery->set($employee->gender);
        $sqlQuery->set($employee->socialSituation);
        $sqlQuery->set($employee->bankAccount);
        $sqlQuery->set($employee->dcholarship);
        $sqlQuery->set($employee->extradayval);

        $id = $this->executeInsert($sqlQuery);
        $employee->employeeId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param EmployeeMySql employee
     */
    public function update($employee) {
        $sql = 'UPDATE employee SET employeeName = ?, employeeBOD = ?, employeeAddress = ?, employeePhone = ?, employeeSalary = ?, employeeBouns = ?, employeeDate = ?, conditions = ?, userId = ?, username = ?, isworker = ?, Hourlyrate = ?, houseAllowance = ?, transportationAllowance = ?, otherAllowance = ?, nationality = ?, religion = ?, noOfWorkDaysPerMonth = ?, noOfWorkHoursDaysPerDay = ?, noOfDistountDaysWhenAbsences = ?, contract = ?, residence = ?, personalPhoto = ?, healthCard = ?, visa = ?, passport = ?, minuteLateCost = ?, dayAbsencesCost = ?, graduate = ?, expert1 = ?, expert2 = ?, expert3 = ?, employeegroupid = ?, employeesubgroupid = ?, halfHourLateWithPermissionDisount = ?, hourLateWithPermissionDisount = ?, hourAndHalfLateWithPermissionDisount = ?, twoHoursLateWithPermissionDisount = ?, halfHourLateWithoutPermissionDisount = ?, hourLateWithoutPermissionDisount = ?, hourAndHalfLateWithoutPermissionDisount = ?, twoHoursLateWithoutPermissionDisount = ?, halfHourPermissionDisount = ?, hourPermissionDisount = ?, hourAndHalfPermissionDisount = ?, twoHoursPermissionDisount = ?, dayAbsenceWithPermissionDisount = ?, dayAbsenceWithoutPermissionDisount = ?,moreThanTwoHoursLateWithPermissionDisount = ?,moreThanTwoHoursLateWithoutPermissionDisount = ?,empFingerId = ?,empRFID = ?,empFingerId2 = ?,empFingerId3 =?,empFingerId4 = ?,empFingerId5 = ?,numberOfMinutesOfDelayAllowed = ?,takeVacationDays = ?,quarterHourLateWithPermissionDisount = ?,quarterHourLateWithoutPermissionDisount = ?, numberOfCountsOfDelayAllowed = ?, branchid = ?, empCode = ?,socialInsurance=?,workTax=?,sysdate=?,birthCertificate=?, armyPhoto=?, idCard=?, driverLicense=?, endorsementPeace=?, confidentialityDeclaration=?, criminalCamouflage=?, practiceProfession=?, socialStatus=?, administration=?, worthExtra=?, subManagement=?, directManager=?, occupation=?, dateBeing=?, gender=?, socialSituation=?, bankAccount=?, dcholarship=?, extradayval=? WHERE employeeId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($employee->employeeName);
        $sqlQuery->set($employee->employeeBOD);
        $sqlQuery->setString2($employee->employeeAddress);
        $sqlQuery->set($employee->employeePhone);
        $sqlQuery->set($employee->employeeSalary);
        $sqlQuery->set($employee->employeeBouns);
        $sqlQuery->set($employee->employeeDate);
        $sqlQuery->setNumber($employee->conditions);
        $sqlQuery->setNumber($employee->userId);
        $sqlQuery->set($employee->username);
        $sqlQuery->setNumber($employee->isworker);
        $sqlQuery->set($employee->hourlyrate);
        $sqlQuery->set($employee->houseAllowance);
        $sqlQuery->set($employee->transportationAllowance);
        $sqlQuery->set($employee->otherAllowance);
        $sqlQuery->set($employee->nationality);
        $sqlQuery->set($employee->religion);
        $sqlQuery->setNumber($employee->noOfWorkDaysPerMonth);
        $sqlQuery->setNumber($employee->noOfWorkHoursDaysPerDay);
        $sqlQuery->setNumber($employee->noOfDistountDaysWhenAbsences);
        $sqlQuery->set($employee->contract);
        $sqlQuery->set($employee->residence);
        $sqlQuery->set($employee->personalPhoto);
        $sqlQuery->set($employee->healthCard);
        $sqlQuery->set($employee->visa);
        $sqlQuery->set($employee->passport);
        $sqlQuery->set($employee->minuteLateCost);
        $sqlQuery->set($employee->dayAbsencesCost);
        $sqlQuery->set($employee->graduate);
        $sqlQuery->set($employee->expert1);
        $sqlQuery->set($employee->expert2);
        $sqlQuery->set($employee->expert3);
        $sqlQuery->set($employee->employeegroupid);
        $sqlQuery->set($employee->employeesubgroupid);
        $sqlQuery->set($employee->halfHourLateWithPermissionDisount);
        $sqlQuery->set($employee->hourLateWithPermissionDisount);
        $sqlQuery->set($employee->hourAndHalfLateWithPermissionDisount);
        $sqlQuery->set($employee->twoHoursLateWithPermissionDisount);
        $sqlQuery->set($employee->halfHourLateWithoutPermissionDisount);
        $sqlQuery->set($employee->hourLateWithoutPermissionDisount);
        $sqlQuery->set($employee->hourAndHalfLateWithoutPermissionDisount);
        $sqlQuery->set($employee->twoHoursLateWithoutPermissionDisount);
        $sqlQuery->set($employee->halfHourPermissionDisount);
        $sqlQuery->set($employee->hourPermissionDisount);
        $sqlQuery->set($employee->hourAndHalfPermissionDisount);
        $sqlQuery->set($employee->twoHoursPermissionDisount);
        $sqlQuery->set($employee->dayAbsenceWithPermissionDisount);
        $sqlQuery->set($employee->dayAbsenceWithoutPermissionDisount);
        $sqlQuery->set($employee->moreThanTwoHoursLateWithPermissionDisount);
        $sqlQuery->set($employee->moreThanTwoHoursLateWithoutPermissionDisount);
        $sqlQuery->set($employee->empFingerId);
        $sqlQuery->set($employee->empRFID);
        $sqlQuery->set($employee->empFingerId2);
        $sqlQuery->set($employee->empFingerId3);
        $sqlQuery->set($employee->empFingerId4);
        $sqlQuery->set($employee->empFingerId5);
        $sqlQuery->setNumber($employee->numberOfMinutesOfDelayAllowed);
        $sqlQuery->setNumber($employee->takeVacationDays);
        $sqlQuery->set($employee->quarterHourLateWithPermissionDisount);
        $sqlQuery->set($employee->quarterHourLateWithoutPermissionDisount);

        $sqlQuery->setNumber((int) $employee->numberOfCountsOfDelayAllowed);
        $sqlQuery->setNumber($employee->branchid);
        $sqlQuery->setNumber($employee->empCode);
        $sqlQuery->setNumber((float) $employee->socialInsurance);
        $sqlQuery->setNumber((float) $employee->workTax);
        $sqlQuery->set($employee->sysdate);
        $sqlQuery->set($employee->birthCertificate);
        $sqlQuery->set($employee->armyPhoto);
        $sqlQuery->set($employee->idCard);
        $sqlQuery->set($employee->driverLicense);
        $sqlQuery->set($employee->endorsementPeace);
        $sqlQuery->set($employee->confidentialityDeclaration);
        $sqlQuery->set($employee->criminalCamouflage);
        $sqlQuery->set($employee->practiceProfession);
        $sqlQuery->set($employee->socialStatus);
        $sqlQuery->set($employee->administration);
        $sqlQuery->set($employee->worthExtra);
        $sqlQuery->set($employee->subManagement);
        $sqlQuery->set($employee->directManager);
        $sqlQuery->set($employee->occupation);
        $sqlQuery->set($employee->dateBeing);
        $sqlQuery->set($employee->gender);
        $sqlQuery->set($employee->socialSituation);
        $sqlQuery->set($employee->bankAccount);
        $sqlQuery->set($employee->dcholarship);
        $sqlQuery->set($employee->extradayval);

        $sqlQuery->setNumber($employee->employeeId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM employee';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByEmployeeName($value) {
        $sql = 'SELECT * FROM employee WHERE employeeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeBOD($value) {
        $sql = 'SELECT * FROM employee WHERE employeeBOD = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeAddress($value) {
        $sql = 'SELECT * FROM employee WHERE employeeAddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeePhone($value) {
        $sql = 'SELECT * FROM employee WHERE employeePhone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeSalary($value) {
        $sql = 'SELECT * FROM employee WHERE employeeSalary = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeBouns($value) {
        $sql = 'SELECT * FROM employee WHERE employeeBouns = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeDate($value) {
        $sql = 'SELECT * FROM employee WHERE employeeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM employee WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM employee WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmpdept($value) {
        $sql = 'SELECT * FROM employee WHERE empdept = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsworker($value) {
        $sql = 'SELECT * FROM employee WHERE isworker = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHourlyrate($value) {
        $sql = 'SELECT * FROM employee WHERE Hourlyrate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHouseAllowance($value) {
        $sql = 'SELECT * FROM employee WHERE houseAllowance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTransportationAllowance($value) {
        $sql = 'SELECT * FROM employee WHERE transportationAllowance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOtherAllowance($value) {
        $sql = 'SELECT * FROM employee WHERE otherAllowance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNationality($value) {
        $sql = 'SELECT * FROM employee WHERE nationality = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReligion($value) {
        $sql = 'SELECT * FROM employee WHERE religion = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNoOfWorkDaysPerMonth($value) {
        $sql = 'SELECT * FROM employee WHERE noOfWorkDaysPerMonth = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNoOfWorkHoursDaysPerDay($value) {
        $sql = 'SELECT * FROM employee WHERE noOfWorkHoursDaysPerDay = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNoOfDistountDaysWhenAbsences($value) {
        $sql = 'SELECT * FROM employee WHERE noOfDistountDaysWhenAbsences = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByContract($value) {
        $sql = 'SELECT * FROM employee WHERE contract = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByResidence($value) {
        $sql = 'SELECT * FROM employee WHERE residence = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPersonalPhoto($value) {
        $sql = 'SELECT * FROM employee WHERE personalPhoto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHealthCard($value) {
        $sql = 'SELECT * FROM employee WHERE healthCard = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByVisa($value) {
        $sql = 'SELECT * FROM employee WHERE visa = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPassport($value) {
        $sql = 'SELECT * FROM employee WHERE passport = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMinuteLateCost($value) {
        $sql = 'SELECT * FROM employee WHERE minuteLateCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDayAbsencesCost($value) {
        $sql = 'SELECT * FROM employee WHERE dayAbsencesCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByEmployeeName($value) {
        $sql = 'DELETE FROM employee WHERE employeeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeBOD($value) {
        $sql = 'DELETE FROM employee WHERE employeeBOD = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeAddress($value) {
        $sql = 'DELETE FROM employee WHERE employeeAddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeePhone($value) {
        $sql = 'DELETE FROM employee WHERE employeePhone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeSalary($value) {
        $sql = 'DELETE FROM employee WHERE employeeSalary = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeBouns($value) {
        $sql = 'DELETE FROM employee WHERE employeeBouns = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeDate($value) {
        $sql = 'DELETE FROM employee WHERE employeeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM employee WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM employee WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmpdept($value) {
        $sql = 'DELETE FROM employee WHERE empdept = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsworker($value) {
        $sql = 'DELETE FROM employee WHERE isworker = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHourlyrate($value) {
        $sql = 'DELETE FROM employee WHERE Hourlyrate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHouseAllowance($value) {
        $sql = 'DELETE FROM employee WHERE houseAllowance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTransportationAllowance($value) {
        $sql = 'DELETE FROM employee WHERE transportationAllowance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOtherAllowance($value) {
        $sql = 'DELETE FROM employee WHERE otherAllowance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNationality($value) {
        $sql = 'DELETE FROM employee WHERE nationality = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReligion($value) {
        $sql = 'DELETE FROM employee WHERE religion = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNoOfWorkDaysPerMonth($value) {
        $sql = 'DELETE FROM employee WHERE noOfWorkDaysPerMonth = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNoOfWorkHoursDaysPerDay($value) {
        $sql = 'DELETE FROM employee WHERE noOfWorkHoursDaysPerDay = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNoOfDistountDaysWhenAbsences($value) {
        $sql = 'DELETE FROM employee WHERE noOfDistountDaysWhenAbsences = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByContract($value) {
        $sql = 'DELETE FROM employee WHERE contract = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByResidence($value) {
        $sql = 'DELETE FROM employee WHERE residence = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPersonalPhoto($value) {
        $sql = 'DELETE FROM employee WHERE personalPhoto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHealthCard($value) {
        $sql = 'DELETE FROM employee WHERE healthCard = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByVisa($value) {
        $sql = 'DELETE FROM employee WHERE visa = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPassport($value) {
        $sql = 'DELETE FROM employee WHERE passport = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMinuteLateCost($value) {
        $sql = 'DELETE FROM employee WHERE minuteLateCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDayAbsencesCost($value) {
        $sql = 'DELETE FROM employee WHERE dayAbsencesCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return EmployeeMySql
     */
    protected function readRow($row) {
        $employee = new Employee();

        $employee->employeeId = isset($row['employeeId']) ? $row['employeeId'] : '';
        $employee->employeeName = isset($row['employeeName']) ? $row['employeeName'] : '';
        $employee->employeeBOD = isset($row['employeeBOD']) ? $row['employeeBOD'] : '';
        $employee->employeeAddress = isset($row['employeeAddress']) ? $row['employeeAddress'] : '';
        $employee->employeePhone = isset($row['employeePhone']) ? $row['employeePhone'] : '';
        $employee->employeeSalary = isset($row['employeeSalary']) ? $row['employeeSalary'] : '';
        $employee->employeeBouns = isset($row['employeeBouns']) ? $row['employeeBouns'] : '';
        $employee->employeeDate = isset($row['employeeDate']) ? $row['employeeDate'] : '';
        $employee->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $employee->userId = isset($row['userId']) ? $row['userId'] : '';
        $employee->username = isset($row['username']) ? $row['username'] : '';
        $employee->empdept = isset($row['empdept']) ? $row['empdept'] : '';
        $employee->isworker = isset($row['isworker']) ? $row['isworker'] : '';
        $employee->hourlyrate = isset($row['Hourlyrate']) ? $row['Hourlyrate'] : '';
        $employee->houseAllowance = isset($row['houseAllowance']) ? $row['houseAllowance'] : '';
        $employee->transportationAllowance = isset($row['transportationAllowance']) ? $row['transportationAllowance'] : '';
        $employee->otherAllowance = isset($row['otherAllowance']) ? $row['otherAllowance'] : '';
        $employee->nationality = isset($row['nationality']) ? $row['nationality'] : '';
        $employee->religion = isset($row['religion']) ? $row['religion'] : '';
        $employee->noOfWorkDaysPerMonth = isset($row['noOfWorkDaysPerMonth']) ? $row['noOfWorkDaysPerMonth'] : '';
        $employee->noOfWorkHoursDaysPerDay = isset($row['noOfWorkHoursDaysPerDay']) ? $row['noOfWorkHoursDaysPerDay'] : '';
        $employee->noOfDistountDaysWhenAbsences = isset($row['noOfDistountDaysWhenAbsences']) ? $row['noOfDistountDaysWhenAbsences'] : '';
        $employee->contract = isset($row['contract']) ? $row['contract'] : '';
        $employee->residence = isset($row['residence']) ? $row['residence'] : '';
        $employee->personalPhoto = isset($row['personalPhoto']) ? $row['personalPhoto'] : '';
        $employee->healthCard = isset($row['healthCard']) ? $row['healthCard'] : '';
        $employee->visa = isset($row['visa']) ? $row['visa'] : '';
        $employee->passport = isset($row['passport']) ? $row['passport'] : '';
        $employee->minuteLateCost = isset($row['minuteLateCost']) ? $row['minuteLateCost'] : '';
        $employee->dayAbsencesCost = isset($row['dayAbsencesCost']) ? $row['dayAbsencesCost'] : '';
        $employee->quarterHourLateWithPermissionDisount = isset($row['quarterHourLateWithPermissionDisount']) ? $row['quarterHourLateWithPermissionDisount'] : '';
        $employee->quarterHourLateWithoutPermissionDisount = isset($row['quarterHourLateWithoutPermissionDisount']) ? $row['quarterHourLateWithoutPermissionDisount'] : '';
        $employee->numberOfCountsOfDelayAllowed = isset($row['numberOfCountsOfDelayAllowed']) ? $row['numberOfCountsOfDelayAllowed'] : '';
        $employee->branchid = $row['branchid'];
        //req
        $employee->Reward = isset($row['Reward']) ? $row['Reward'] : '';
        $employee->Discount = isset($row['Discount']) ? $row['Discount'] : '';
        $employee->Withdraw = isset($row['Withdraw']) ? $row['Withdraw'] : '';
        $employee->Absence = isset($row['Absence']) ? $row['Absence'] : '';
        $employee->Repayment = isset($row['Repayment']) ? $row['Repayment'] : '';
        $employee->permission = isset($row['permission']) ? $row['permission'] : '';
        $employee->graduate = isset($row['graduate']) ? $row['graduate'] : '';
        $employee->expert1 = isset($row['expert1']) ? $row['expert1'] : '';
        $employee->expert2 = isset($row['expert2']) ? $row['expert2'] : '';
        $employee->expert3 = isset($row['expert3']) ? $row['expert3'] : '';
        $employee->employeegroupid = isset($row['employeegroupid']) ? $row['employeegroupid'] : '';
        $employee->employeesubgroupid = isset($row['employeesubgroupid']) ? $row['employeesubgroupid'] : '';
        $employee->halfHourLateWithPermissionDisount = $row['halfHourLateWithPermissionDisount'];
        $employee->hourLateWithPermissionDisount = $row['hourLateWithPermissionDisount'];
        $employee->hourAndHalfLateWithPermissionDisount = $row['hourAndHalfLateWithPermissionDisount'];
        $employee->twoHoursLateWithPermissionDisount = $row['twoHoursLateWithPermissionDisount'];
        $employee->halfHourLateWithoutPermissionDisount = $row['halfHourLateWithoutPermissionDisount'];
        $employee->hourLateWithoutPermissionDisount = $row['hourLateWithoutPermissionDisount'];
        $employee->hourAndHalfLateWithoutPermissionDisount = $row['hourAndHalfLateWithoutPermissionDisount'];
        $employee->twoHoursLateWithoutPermissionDisount = $row['twoHoursLateWithoutPermissionDisount'];
        $employee->halfHourPermissionDisount = $row['halfHourPermissionDisount'];
        $employee->hourPermissionDisount = $row['hourPermissionDisount'];
        $employee->hourAndHalfPermissionDisount = $row['hourAndHalfPermissionDisount'];
        $employee->twoHoursPermissionDisount = $row['twoHoursPermissionDisount'];
        $employee->dayAbsenceWithPermissionDisount = $row['dayAbsenceWithPermissionDisount'];
        $employee->dayAbsenceWithoutPermissionDisount = $row['dayAbsenceWithoutPermissionDisount'];
        $employee->moreThanTwoHoursLateWithPermissionDisount = $row['moreThanTwoHoursLateWithPermissionDisount'];
        $employee->moreThanTwoHoursLateWithoutPermissionDisount = $row['moreThanTwoHoursLateWithoutPermissionDisount'];
        $employee->empFingerId = $row['empFingerId'];
        $employee->empRFID = $row['empRFID'];
        $employee->empFingerId2 = $row['empFingerId2'];
        $employee->empFingerId3 = $row['empFingerId3'];
        $employee->empFingerId4 = $row['empFingerId4'];
        $employee->empFingerId5 = $row['empFingerId5'];
        $employee->numberOfMinutesOfDelayAllowed = $row['numberOfMinutesOfDelayAllowed'];
        $employee->takeVacationDays = $row['takeVacationDays'];
        $employee->treeId = $row['treeId'];
        $employee->treeId2 = $row['treeId2'];
        //
        $employee->id = $row['id']; //employeeclosedayhistoryid
        $employee->day = $row['day'];
        $employee->attendanceTime = $row['attendanceTime'];
        $employee->departureTime = $row['departureTime'];
        $employee->latePeriod = $row['latePeriod'];
        $employee->lateHasPermission = $row['lateHasPermission'];
        $employee->lateDiscount = $row['lateDiscount'];
        $employee->isAbsent = $row['isAbsent'];
        $employee->absentHasPermission = $row['absentHasPermission'];
        $employee->absentDiscount = $row['absentDiscount'];
        $employee->status = $row['status'];
        $employee->groupName = $row['groupName'];
        $employee->supgroupName = $row['supgroupName'];
        $employee->sysdate = $row['sysdate'];
        $employee->empCode = $row['empCode'];
        $employee->socialInsurance = $row['socialInsurance'];
        $employee->workTax = $row['workTax'];
        $employee->allLeave = isset($row['allLeave']) ? $row['allLeave'] : '';

        $employee->birthCertificate = isset($row['birthCertificate'])? $row['birthCertificate'] : '';
        $employee->armyPhoto = isset($row['armyPhoto'])? $row['armyPhoto'] : '';
        $employee->idCard = isset($row['idCard'])? $row['idCard'] : '';
        $employee->driverLicense = isset($row['driverLicense'])? $row['driverLicense'] : '';
        $employee->endorsementPeace = isset($row['endorsementPeace'])? $row['endorsementPeace'] : '';
        $employee->confidentialityDeclaration = isset($row['confidentialityDeclaration'])? $row['confidentialityDeclaration'] : '';
        $employee->criminalCamouflage = isset($row['criminalCamouflage'])? $row['criminalCamouflage'] : '';
        $employee->practiceProfession = isset($row['practiceProfession'])? $row['practiceProfession'] : '';
        $employee->socialStatus = isset($row['socialStatus'])? $row['socialStatus'] : '';
        $employee->administration = isset($row['administration'])? $row['administration'] : '';
        $employee->worthExtra = isset($row['worthExtra'])? $row['worthExtra'] : '';
        $employee->subManagement = isset($row['subManagement'])? $row['subManagement'] : '';
        $employee->directManager = isset($row['directManager'])? $row['directManager'] : '';
        $employee->occupation = isset($row['occupation'])? $row['occupation'] : '';
        $employee->dateBeing = isset($row['dateBeing'])? $row['dateBeing'] : '';
        $employee->gender = isset($row['gender'])? $row['gender'] : '';
        $employee->socialSituation = isset($row['socialSituation'])? $row['socialSituation'] : '';
        $employee->bankAccount = isset($row['bankAccount'])? $row['bankAccount'] : '';
        $employee->dcholarship = isset($row['dcholarship'])? $row['dcholarship'] : '';
        $employee->extradayval = isset($row['extradayval']) ? $row['extradayval'] : '';

        //

        return $employee;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return EmployeeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}
