<?php

/**
 * Class that operate on table 'm_comreceiptdetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MComreceiptdetailMySqlDAO implements MComreceiptdetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MComreceiptdetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_comreceiptdetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_comreceiptdetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mComreceiptdetail primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MComreceiptdetailMySql mComreceiptdetail
     */
    public function insert($mComreceiptdetail) {
        $sql = 'INSERT INTO m_comreceiptdetail (receiptid, productserial, productId, ourserial, granttype, sellbillid, sellbilldate, buybillid, buybilldate, insduration, insstatus, problem, attach, comment, shipcost, initialcost, discount, supplierid, currentstage, branchid, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mComreceiptdetail->receiptid);
        $sqlQuery->set($mComreceiptdetail->productserial);
        $sqlQuery->setNumber($mComreceiptdetail->productId);
        $sqlQuery->set($mComreceiptdetail->ourserial);
        $sqlQuery->setNumber($mComreceiptdetail->granttype);
        $sqlQuery->setNumber($mComreceiptdetail->sellbillid);
        $sqlQuery->set($mComreceiptdetail->sellbilldate);
        $sqlQuery->setNumber($mComreceiptdetail->buybillid);
        $sqlQuery->set($mComreceiptdetail->buybilldate);
        $sqlQuery->setNumber($mComreceiptdetail->insduration);
        $sqlQuery->setNumber($mComreceiptdetail->insstatus);
        $sqlQuery->setString2($mComreceiptdetail->problem);
        $sqlQuery->setString2($mComreceiptdetail->attach);
        $sqlQuery->setString2($mComreceiptdetail->comment);
        $sqlQuery->set($mComreceiptdetail->shipcost);
        $sqlQuery->set($mComreceiptdetail->initialcost);
        $sqlQuery->set($mComreceiptdetail->discount);
        $sqlQuery->setNumber($mComreceiptdetail->supplierid);
        $sqlQuery->setNumber($mComreceiptdetail->currentstage);
        $sqlQuery->setNumber($mComreceiptdetail->branchid);
        $sqlQuery->setNumber($mComreceiptdetail->del);

        $id = $this->executeInsert($sqlQuery);
        $mComreceiptdetail->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MComreceiptdetailMySql mComreceiptdetail
     */
    public function update($mComreceiptdetail) {
        $sql = 'UPDATE m_comreceiptdetail SET receiptid = ?, productserial = ?, productId = ?, ourserial = ?, granttype = ?, sellbillid = ?, sellbilldate = ?, buybillid = ?, buybilldate = ?, insduration = ?, insstatus = ?, problem = ?, attach = ?, comment = ?, shipcost = ?, initialcost = ?, discount = ?, supplierid = ?, currentstage = ?, branchid = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mComreceiptdetail->receiptid);
        $sqlQuery->set($mComreceiptdetail->productserial);
        $sqlQuery->setNumber($mComreceiptdetail->productId);
        $sqlQuery->set($mComreceiptdetail->ourserial);
        $sqlQuery->setNumber($mComreceiptdetail->granttype);
        $sqlQuery->setNumber($mComreceiptdetail->sellbillid);
        $sqlQuery->set($mComreceiptdetail->sellbilldate);
        $sqlQuery->setNumber($mComreceiptdetail->buybillid);
        $sqlQuery->set($mComreceiptdetail->buybilldate);
        $sqlQuery->setNumber($mComreceiptdetail->insduration);
        $sqlQuery->setNumber($mComreceiptdetail->insstatus);
        $sqlQuery->setString2($mComreceiptdetail->problem);
        $sqlQuery->setString2($mComreceiptdetail->attach);
        $sqlQuery->setString2($mComreceiptdetail->comment);
        $sqlQuery->set($mComreceiptdetail->shipcost);
        $sqlQuery->set($mComreceiptdetail->initialcost);
        $sqlQuery->set($mComreceiptdetail->discount);
        $sqlQuery->setNumber($mComreceiptdetail->supplierid);
        $sqlQuery->setNumber($mComreceiptdetail->currentstage);
        $sqlQuery->setNumber($mComreceiptdetail->branchid);
        $sqlQuery->setNumber($mComreceiptdetail->del);



        $sqlQuery->setNumber($mComreceiptdetail->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_comreceiptdetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByReceiptid($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE receiptid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductserial($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE productserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOurserial($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE ourserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByGranttype($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE granttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillid($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldate($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillid($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldate($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE buybilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInsduration($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE insduration = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInsstatus($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE insstatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProblem($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE problem = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAttach($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE attach = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShipcost($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE shipcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInitialcost($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE initialcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierid($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentstage($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE currentstage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchid($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE branchid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_comreceiptdetail WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByReceiptid($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE receiptid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductserial($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE productserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOurserial($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE ourserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByGranttype($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE granttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillid($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldate($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillid($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldate($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE buybilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInsduration($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE insduration = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInsstatus($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE insstatus = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProblem($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE problem = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAttach($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE attach = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShipcost($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE shipcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInitialcost($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE initialcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierid($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentstage($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE currentstage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchid($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE branchid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_comreceiptdetail WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MComreceiptdetailMySql
     */
    protected function readRow($row) {
        $mComreceiptdetail = new MComreceiptdetail();

        $mComreceiptdetail->id = isset($row['id']) ? $row['id'] : '';
        $mComreceiptdetail->receiptid = isset($row['receiptid']) ? $row['receiptid'] : '';
        $mComreceiptdetail->productserial = isset($row['productserial']) ? $row['productserial'] : '';
        $mComreceiptdetail->productId = isset($row['productId']) ? $row['productId'] : '';
        $mComreceiptdetail->ourserial = isset($row['ourserial']) ? $row['ourserialourserial'] : '';
        $mComreceiptdetail->granttype = isset($row['granttype']) ? $row['granttype'] : '';
        $mComreceiptdetail->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $mComreceiptdetail->sellbilldate = isset($row['sellbilldate']) ? $row['sellbilldate'] : '';
        $mComreceiptdetail->buybillid = isset($row['buybillid']) ? $row['buybillid'] : '';
        $mComreceiptdetail->buybilldate = isset($row['buybilldate']) ? $row['buybilldate'] : '';
        $mComreceiptdetail->insduration = isset($row['insduration']) ? $row['insduration'] : '';
        $mComreceiptdetail->insstatus = isset($row['insstatus']) ? $row['insstatus'] : '';
        $mComreceiptdetail->problem = isset($row['problem']) ? $row['problem'] : '';
        $mComreceiptdetail->attach = isset($row['attach']) ? $row['attach'] : '';
        $mComreceiptdetail->comment = isset($row['comment']) ? $row['comment'] : '';
        $mComreceiptdetail->shipcost = isset($row['shipcost']) ? $row['shipcost'] : '';
        $mComreceiptdetail->initialcost = isset($row['initialcost']) ? $row['initialcost'] : '';
        $mComreceiptdetail->discount = isset($row['discount']) ? $row['discount'] : '';
        $mComreceiptdetail->supplierid = isset($row['supplierid']) ? $row['supplierid'] : '';
        $mComreceiptdetail->currentstage = isset($row['currentstage']) ? $row['currentstage'] : '';
        $mComreceiptdetail->branchid = isset($row['branchid']) ? $row['branchid'] : '';
        $mComreceiptdetail->del = isset($row['del']) ? $row['del'] : '';
        $mComreceiptdetail->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';

        $mComreceiptdetail->productName = isset($row['productName']) ? $row['productName'] : '';
        $mComreceiptdetail->myCount = isset($row['myCount']) ? $row['myCount'] : '';
        $mComreceiptdetail->stageFrom = isset($row['stageFrom']) ? $row['stageFrom'] : '';
        $mComreceiptdetail->stageTo = isset($row['stageTo']) ? $row['stageTo'] : '';
        $mComreceiptdetail->cost = isset($row['cost']) ? $row['cost'] : '';
        $mComreceiptdetail->status = isset($row['status']) ? $row['status'] : '';
        $mComreceiptdetail->productHistoryId = isset($row['productHistoryId']) ? $row['productHistoryId'] : '';
        $mComreceiptdetail->checkId = isset($row['checkId']) ? $row['checkId'] : '';
        $mComreceiptdetail->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $mComreceiptdetail->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $mComreceiptdetail->receiptserial = isset($row['receiptserial']) ? $row['receiptserial'] : '';
        $mComreceiptdetail->title = isset($row['receiptserial']) ? $row['receiptserial'] : '';

        $mComreceiptdetail->value = isset($row['value']) ? $row['value'] : '';
        $mComreceiptdetail->label = isset($row['label']) ? $row['label'] : '';

        return $mComreceiptdetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MComreceiptdetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>