<?php

/**
 * Class that operate on table 'newdbname'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-08-12 12:38
 */
class NewdbnameMySqlDAO implements NewdbnameDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return NewdbnameMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM newdbname WHERE newdbnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM newdbname';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM newdbname ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param newdbname primary key
     */
    public function delete($newdbnameid) {
        $sql = 'DELETE FROM newdbname WHERE newdbnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($newdbnameid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param NewdbnameMySql newdbname
     */
    public function insert($newdbname) {
        $sql = 'INSERT INTO newdbname (dbname) VALUES (?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($newdbname->dbname);

        $id = $this->executeInsert($sqlQuery);
        $newdbname->newdbnameid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param NewdbnameMySql newdbname
     */
    public function update($newdbname) {
        $sql = 'UPDATE newdbname SET dbname = ? WHERE newdbnameid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($newdbname->dbname);

        $sqlQuery->setNumber($newdbname->newdbnameid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM newdbname';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByDbname($value) {
        $sql = 'SELECT * FROM newdbname WHERE dbname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByDbname($value) {
        $sql = 'DELETE FROM newdbname WHERE dbname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return NewdbnameMySql
     */
    protected function readRow($row) {
        $newdbname = new Newdbname();

        $newdbname->newdbnameid = isset($row['newdbnameid']) ? $row['newdbnameid'] : '';
        $newdbname->dbname = isset($row['dbname']) ? $row['dbname'] : '';

        return $newdbname;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return NewdbnameMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>