<?php

/**
 * Class that operate on table 'pages'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2025-05-13 00:18
 */
class PagesMySqlDAO implements PagesDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return PagesMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM pages WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM pages';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM pages ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param page primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM pages WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param PagesMySql page
     */
    public function insert($page) {
        $sql = 'INSERT INTO pages (title, titleEn, contentOrExternalLink, externalLink, openTarget, content, contentEn, isActive, image, sysDate, userid, isdel) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($page->title);
        $sqlQuery->set($page->titleEn);
        $sqlQuery->setNumber($page->contentOrExternalLink);
        $sqlQuery->set($page->externalLink);
        $sqlQuery->setNumber((int) $page->openTarget);
        $sqlQuery->setString2($page->content);
        $sqlQuery->setString2($page->contentEn);
        $sqlQuery->setNumber($page->isActive);
        $sqlQuery->set($page->image);
        $sqlQuery->set($page->sysDate);
        $sqlQuery->setNumber($page->userid);
        $sqlQuery->setNumber($page->isdel);

        $id = $this->executeInsert($sqlQuery);
        $page->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param PagesMySql page
     */
    public function update($page) {
        $sql = 'UPDATE pages SET title = ?, titleEn = ?, contentOrExternalLink = ?, externalLink = ?, openTarget = ?, content = ?, contentEn = ?, isActive = ?, image = ?, sysDate = ?, userid = ?, isdel = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($page->title);
        $sqlQuery->set($page->titleEn);
        $sqlQuery->setNumber($page->contentOrExternalLink);
        $sqlQuery->set($page->externalLink);
        $sqlQuery->setNumber((int) $page->openTarget);
        $sqlQuery->setString2($page->content);
        $sqlQuery->setString2($page->contentEn);
        $sqlQuery->setNumber($page->isActive);
        $sqlQuery->set($page->image);
        $sqlQuery->set($page->sysDate);
        $sqlQuery->setNumber($page->userid);
        $sqlQuery->setNumber($page->isdel);

        $sqlQuery->setNumber($page->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM pages';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByTitle($value) {
        $sql = 'SELECT * FROM pages WHERE title = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTitleEn($value) {
        $sql = 'SELECT * FROM pages WHERE titleEn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByContentOrExternalLink($value) {
        $sql = 'SELECT * FROM pages WHERE contentOrExternalLink = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExternalLink($value) {
        $sql = 'SELECT * FROM pages WHERE externalLink = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOpenTarget($value) {
        $sql = 'SELECT * FROM pages WHERE openTarget = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByContent($value) {
        $sql = 'SELECT * FROM pages WHERE content = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByContentEn($value) {
        $sql = 'SELECT * FROM pages WHERE contentEn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsActive($value) {
        $sql = 'SELECT * FROM pages WHERE isActive = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByImage($value) {
        $sql = 'SELECT * FROM pages WHERE image = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysDate($value) {
        $sql = 'SELECT * FROM pages WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM pages WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsdel($value) {
        $sql = 'SELECT * FROM pages WHERE isdel = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByTitle($value) {
        $sql = 'DELETE FROM pages WHERE title = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTitleEn($value) {
        $sql = 'DELETE FROM pages WHERE titleEn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByContentOrExternalLink($value) {
        $sql = 'DELETE FROM pages WHERE contentOrExternalLink = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExternalLink($value) {
        $sql = 'DELETE FROM pages WHERE externalLink = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOpenTarget($value) {
        $sql = 'DELETE FROM pages WHERE openTarget = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByContent($value) {
        $sql = 'DELETE FROM pages WHERE content = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByContentEn($value) {
        $sql = 'DELETE FROM pages WHERE contentEn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsActive($value) {
        $sql = 'DELETE FROM pages WHERE isActive = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByImage($value) {
        $sql = 'DELETE FROM pages WHERE image = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysDate($value) {
        $sql = 'DELETE FROM pages WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM pages WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsdel($value) {
        $sql = 'DELETE FROM pages WHERE isdel = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return PagesMySql
     */
    protected function readRow($row) {
        $page = new Page();

        $page->id = $row['id'];
        $page->title = $row['title'];
        $page->titleEn = $row['titleEn'];
        $page->contentOrExternalLink = $row['contentOrExternalLink'];
        $page->externalLink = $row['externalLink'];
        $page->openTarget = $row['openTarget'];
        $page->content = $row['content'];
        $page->contentEn = $row['contentEn'];
        $page->isActive = $row['isActive'];
        $page->image = $row['image'];
        $page->sysDate = $row['sysDate'];
        $page->userid = $row['userid'];
        $page->isdel = $row['isdel'];

        return $page;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return PagesMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>