<?php

/**
 * Class that operate on table 'properties'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class PropertiesMySqlDAO implements PropertiesDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return PropertiesMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM properties WHERE propertyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll($queryString = '') {
        $sql = 'SELECT * FROM properties ' . $queryString;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM properties ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param propertie primary key
     */
    public function delete($propertyid) {
        $sql = 'DELETE FROM properties WHERE propertyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($propertyid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param PropertiesMySql propertie
     */
    public function insert($propertie) {
        $sql = 'INSERT INTO properties (propertyname, propertyparent, propertydefault, propertyurl,propertyname_en) VALUES (?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($propertie->propertyname);
        $sqlQuery->setNumber($propertie->propertyparent);
        $sqlQuery->setNumber($propertie->propertydefault);
        $sqlQuery->set($propertie->propertyurl);
        $sqlQuery->set($propertie->propertyname_en);

        $id = $this->executeInsert($sqlQuery);
        $propertie->propertyid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param PropertiesMySql propertie
     */
    public function update($propertie) {
        $sql = 'UPDATE properties SET propertyname = ?, propertyparent = ?, propertydefault = ?, propertyurl = ?, propertyname_en = ?  WHERE propertyid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($propertie->propertyname);
        $sqlQuery->setNumber($propertie->propertyparent);
        $sqlQuery->setNumber($propertie->propertydefault);
        $sqlQuery->set($propertie->propertyurl);
        $sqlQuery->set($propertie->propertyname_en);

        $sqlQuery->setNumber($propertie->propertyid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM properties';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByPropertyname($value) {
        $sql = 'SELECT * FROM properties WHERE propertyname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPropertyparent($value) {
        $sql = 'SELECT * FROM properties WHERE propertyparent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPropertydefault($value) {
        $sql = 'SELECT * FROM properties WHERE propertydefault = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPropertyurl($value) {
        $sql = 'SELECT * FROM properties WHERE propertyurl = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByPropertyname($value) {
        $sql = 'DELETE FROM properties WHERE propertyname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPropertyparent($value) {
        $sql = 'DELETE FROM properties WHERE propertyparent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPropertydefault($value) {
        $sql = 'DELETE FROM properties WHERE propertydefault = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPropertyurl($value) {
        $sql = 'DELETE FROM properties WHERE propertyurl = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return PropertiesMySql
     */
    protected function readRow($row) {
        $propertie = new Propertie();

        $propertie->propertyid = isset($row['propertyid']) ? $row['propertyid'] : '';
        $propertie->propertyname = isset($row['propertyname']) ? $row['propertyname'] : '';
        $propertie->propertyparent = isset($row['propertyparent']) ? $row['propertyparent'] : '';
        $propertie->propertydefault = isset($row['propertydefault']) ? $row['propertydefault'] : '';
        $propertie->propertyurl = isset($row['propertyurl']) ? $row['propertyurl'] : '';
        $propertie->isallowed = isset($row['isallowed']) ? $row['isallowed'] : '';
        $propertie->propertyname_en = isset($row['propertyname_en']) ? $row['propertyname_en'] : '';

        return $propertie;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return PropertiesMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>