<?php

/**
 * Class that operate on table 'quickprofitgeneral'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-01-27 09:50
 */
class QuickprofitgeneralMySqlDAO implements QuickprofitgeneralDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return QuickprofitgeneralMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM quickprofitgeneral WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM quickprofitgeneral';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM quickprofitgeneral ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param quickprofitgeneral primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM quickprofitgeneral WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param QuickprofitgeneralMySql quickprofitgeneral
     */
    public function insert($quickprofitgeneral) {
        $sql = 'INSERT INTO quickprofitgeneral (netSellVal, netSellCostBuyPrice, netSellCostLastBuyPrice, netSellCostMeanBuyPrice, netSellCostLastBuyPricewithDiscount, netSellCostMeanBuyPricewithDiscount) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($quickprofitgeneral->netSellVal);
        $sqlQuery->set($quickprofitgeneral->netSellCostBuyPrice);
        $sqlQuery->set($quickprofitgeneral->netSellCostLastBuyPrice);
        $sqlQuery->set($quickprofitgeneral->netSellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitgeneral->netSellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitgeneral->netSellCostMeanBuyPricewithDiscount);

        $id = $this->executeInsert($sqlQuery);
        $quickprofitgeneral->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param QuickprofitgeneralMySql quickprofitgeneral
     */
    public function update($quickprofitgeneral) {
        $sql = 'UPDATE quickprofitgeneral SET netSellVal = ?, netSellCostBuyPrice = ?, netSellCostLastBuyPrice = ?, netSellCostMeanBuyPrice = ?, netSellCostLastBuyPricewithDiscount = ?, netSellCostMeanBuyPricewithDiscount = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($quickprofitgeneral->netSellVal);
        $sqlQuery->set($quickprofitgeneral->netSellCostBuyPrice);
        $sqlQuery->set($quickprofitgeneral->netSellCostLastBuyPrice);
        $sqlQuery->set($quickprofitgeneral->netSellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitgeneral->netSellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitgeneral->netSellCostMeanBuyPricewithDiscount);

        $sqlQuery->setNumber($quickprofitgeneral->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM quickprofitgeneral';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByNetSellVal($value) {
        $sql = 'SELECT * FROM quickprofitgeneral WHERE netSellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNetSellCostBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitgeneral WHERE netSellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNetSellCostLastBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitgeneral WHERE netSellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNetSellCostMeanBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitgeneral WHERE netSellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNetSellCostLastBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitgeneral WHERE netSellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNetSellCostMeanBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitgeneral WHERE netSellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByNetSellVal($value) {
        $sql = 'DELETE FROM quickprofitgeneral WHERE netSellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNetSellCostBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitgeneral WHERE netSellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNetSellCostLastBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitgeneral WHERE netSellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNetSellCostMeanBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitgeneral WHERE netSellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNetSellCostLastBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitgeneral WHERE netSellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNetSellCostMeanBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitgeneral WHERE netSellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return QuickprofitgeneralMySql
     */
    protected function readRow($row) {
        $quickprofitgeneral = new Quickprofitgeneral();

        $quickprofitgeneral->id = $row['id'];
        $quickprofitgeneral->netSellVal = $row['netSellVal'];
        $quickprofitgeneral->netSellCostBuyPrice = $row['netSellCostBuyPrice'];
        $quickprofitgeneral->netSellCostLastBuyPrice = $row['netSellCostLastBuyPrice'];
        $quickprofitgeneral->netSellCostMeanBuyPrice = $row['netSellCostMeanBuyPrice'];
        $quickprofitgeneral->netSellCostLastBuyPricewithDiscount = $row['netSellCostLastBuyPricewithDiscount'];
        $quickprofitgeneral->netSellCostMeanBuyPricewithDiscount = $row['netSellCostMeanBuyPricewithDiscount'];
        $quickprofitgeneral->netSellCostOverAllAveragePrice = $row['netSellCostOverAllAveragePrice'];

        return $quickprofitgeneral;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return QuickprofitgeneralMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>