<?php

/**
 * Class that operate on table 'restaurantplaystation'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-04-05 21:25
 */
class RestaurantplaystationMySqlDAO implements RestaurantplaystationDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RestaurantplaystationMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM restaurantplaystation WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM restaurantplaystation';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM restaurantplaystation ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param restaurantplaystation primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM restaurantplaystation WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RestaurantplaystationMySql restaurantplaystation
     */
    public function insert($restaurantplaystation) {
        $sql = 'INSERT INTO restaurantplaystation (name, hourPrice, beingUsed, tableId, serviceId, userId, sysdate,deviceIdentification,subDeviceIdentification,useSubIdentification,hourPriceMulti) VALUES (?, ?, ?, ?, ?, ?, ?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($restaurantplaystation->name);
        $sqlQuery->set($restaurantplaystation->hourPrice);
        $sqlQuery->setNumber($restaurantplaystation->beingUsed);
        $sqlQuery->setNumber($restaurantplaystation->tableId);
        $sqlQuery->setNumber($restaurantplaystation->serviceId);
        $sqlQuery->setNumber($restaurantplaystation->userId);
        $sqlQuery->set($restaurantplaystation->sysdate);
        $sqlQuery->set($restaurantplaystation->deviceIdentification);
        $sqlQuery->set($restaurantplaystation->subDeviceIdentification);
        $sqlQuery->set((int) $restaurantplaystation->useSubIdentification);
        $sqlQuery->set((float) $restaurantplaystation->hourPriceMulti);

        $id = $this->executeInsert($sqlQuery);
        $restaurantplaystation->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RestaurantplaystationMySql restaurantplaystation
     */
    public function update($restaurantplaystation) {
        $sql = 'UPDATE restaurantplaystation SET name = ?, hourPrice = ?, beingUsed = ?, tableId = ?, serviceId = ?, userId = ?, sysdate = ?,deviceIdentification = ?,subDeviceIdentification=?,useSubIdentification=?,hourPriceMulti=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($restaurantplaystation->name);
        $sqlQuery->set($restaurantplaystation->hourPrice);
        $sqlQuery->setNumber($restaurantplaystation->beingUsed);
        $sqlQuery->setNumber($restaurantplaystation->tableId);
        $sqlQuery->setNumber($restaurantplaystation->serviceId);
        $sqlQuery->setNumber($restaurantplaystation->userId);
        $sqlQuery->set($restaurantplaystation->sysdate);
        $sqlQuery->set($restaurantplaystation->deviceIdentification);
        $sqlQuery->set($restaurantplaystation->subDeviceIdentification);
        $sqlQuery->set((int) $restaurantplaystation->useSubIdentification);
        $sqlQuery->set((float) $restaurantplaystation->hourPriceMulti);

        $sqlQuery->setNumber($restaurantplaystation->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM restaurantplaystation';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM restaurantplaystation WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHourPrice($value) {
        $sql = 'SELECT * FROM restaurantplaystation WHERE hourPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBeingUsed($value) {
        $sql = 'SELECT * FROM restaurantplaystation WHERE beingUsed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTableId($value) {
        $sql = 'SELECT * FROM restaurantplaystation WHERE tableId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByServiceId($value) {
        $sql = 'SELECT * FROM restaurantplaystation WHERE serviceId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM restaurantplaystation WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM restaurantplaystation WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM restaurantplaystation WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHourPrice($value) {
        $sql = 'DELETE FROM restaurantplaystation WHERE hourPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBeingUsed($value) {
        $sql = 'DELETE FROM restaurantplaystation WHERE beingUsed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTableId($value) {
        $sql = 'DELETE FROM restaurantplaystation WHERE tableId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByServiceId($value) {
        $sql = 'DELETE FROM restaurantplaystation WHERE serviceId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM restaurantplaystation WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM restaurantplaystation WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RestaurantplaystationMySql
     */
    protected function readRow($row) {
        $restaurantplaystation = new Restaurantplaystation();

        $restaurantplaystation->id = $row['id'];
        $restaurantplaystation->name = $row['name'];
        $restaurantplaystation->hourPrice = $row['hourPrice'];
        $restaurantplaystation->beingUsed = $row['beingUsed'];
        $restaurantplaystation->tableId = $row['tableId'];
        $restaurantplaystation->serviceId = $row['serviceId'];
        $restaurantplaystation->userId = $row['userId'];
        $restaurantplaystation->sysdate = $row['sysdate'];
        $restaurantplaystation->deviceIdentification = $row['deviceIdentification'];
        $restaurantplaystation->subDeviceIdentification = $row['subDeviceIdentification'];
        $restaurantplaystation->useSubIdentification = $row['useSubIdentification'];
        $restaurantplaystation->hourPriceMulti = $row['hourPriceMulti'];
        //
        $restaurantplaystation->hallid = $row['hallid'];
        $restaurantplaystation->startsysDate = $row['startsysDate'];
        $restaurantplaystation->reservationType = $row['reservationType'];
        $restaurantplaystation->reservationEndDateTime = $row['reservationEndDateTime'];
        $restaurantplaystation->priceIs = $row['priceIs'];

        return $restaurantplaystation;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RestaurantplaystationMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>