<?php

/**
 * Class that operate on table 'restauranttable'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2018-05-16 11:37
 */
class RestauranttableMySqlDAO implements RestauranttableDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RestauranttableMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM restauranttable WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM restauranttable';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM restauranttable ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param restauranttable primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM restauranttable WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RestauranttableMySql restauranttable
     */
    public function insert($restauranttable) {
        $sql = 'INSERT INTO restauranttable (hallid, name, beingUsed, userId, sysdate, del) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restauranttable->hallid);
        $sqlQuery->set($restauranttable->name);
        $sqlQuery->setNumber($restauranttable->beingUsed);
        $sqlQuery->setNumber($restauranttable->userId);
        $sqlQuery->set($restauranttable->sysdate);
        $sqlQuery->setNumber($restauranttable->del);

        $id = $this->executeInsert($sqlQuery);
        $restauranttable->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RestauranttableMySql restauranttable
     */
    public function update($restauranttable) {
        $sql = 'UPDATE restauranttable SET hallid = ?, name = ?, beingUsed = ?, userId = ?, sysdate = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($restauranttable->hallid);
        $sqlQuery->set($restauranttable->name);
        $sqlQuery->setNumber($restauranttable->beingUsed);
        $sqlQuery->setNumber($restauranttable->userId);
        $sqlQuery->set($restauranttable->sysdate);
        $sqlQuery->setNumber($restauranttable->del);

        $sqlQuery->setNumber($restauranttable->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM restauranttable';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByHallid($value) {
        $sql = 'SELECT * FROM restauranttable WHERE hallid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM restauranttable WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBeingUsed($value) {
        $sql = 'SELECT * FROM restauranttable WHERE beingUsed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM restauranttable WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM restauranttable WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM restauranttable WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByHallid($value) {
        $sql = 'DELETE FROM restauranttable WHERE hallid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM restauranttable WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBeingUsed($value) {
        $sql = 'DELETE FROM restauranttable WHERE beingUsed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM restauranttable WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM restauranttable WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM restauranttable WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RestauranttableMySql
     */
    protected function readRow($row) {
        $restauranttable = new Restauranttable();

        $restauranttable->id = isset($row['id']) ? $row['id'] : '';
        $restauranttable->hallid = isset($row['hallid']) ? $row['hallid'] : '';
        $restauranttable->name = isset($row['name']) ? $row['name'] : '';
        $restauranttable->beingUsed = isset($row['beingUsed']) ? $row['beingUsed'] : '';
        $restauranttable->userId = isset($row['userId']) ? $row['userId'] : '';
        $restauranttable->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $restauranttable->del = isset($row['del']) ? $row['del'] : '';
        //
        $restauranttable->hallName = isset($row['hallName']) ? $row['hallName'] : '';
        $restauranttable->hallPrice = isset($row['hallPrice']) ? $row['hallPrice'] : '';
        $restauranttable->hallUsers = isset($row['hallUsers']) ? $row['hallUsers'] : '';

        return $restauranttable;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RestauranttableMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>