<?php
/**
 * Class that operate on table 'returnsellbillcurr'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-03-08 08:37
 */
class ReturnsellbillcurrMySqlDAO implements ReturnsellbillcurrDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return ReturnsellbillcurrMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM returnsellbillcurr';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM returnsellbillcurr ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param returnsellbillcurr primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM returnsellbillcurr WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param ReturnsellbillcurrMySql returnsellbillcurr
 	 */
	public function insert($returnsellbillcurr){
		$sql = 'INSERT INTO returnsellbillcurr (returnsellbillid, conversionFactor, returnsellbilldiscountC, returnsellbilltotalbillC, returnsellbillaftertotalbillC, returnsellbilltotalpayedC, returnsellbillfinalbillC, returnsellbildirectpaymentC, taxC, cashPayedC, visaPayedC, extraDiscountValC, taxOfDiscountValC, saveConversionFactor) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($returnsellbillcurr->returnsellbillid);
		$sqlQuery->set($returnsellbillcurr->conversionFactor);
		$sqlQuery->set($returnsellbillcurr->returnsellbilldiscountC);
		$sqlQuery->set($returnsellbillcurr->returnsellbilltotalbillC);
		$sqlQuery->set($returnsellbillcurr->returnsellbillaftertotalbillC);
		$sqlQuery->set($returnsellbillcurr->returnsellbilltotalpayedC);
		$sqlQuery->set($returnsellbillcurr->returnsellbillfinalbillC);
		$sqlQuery->setNumber($returnsellbillcurr->returnsellbildirectpaymentC);
		$sqlQuery->set($returnsellbillcurr->taxC);
		$sqlQuery->set($returnsellbillcurr->cashPayedC);
		$sqlQuery->set($returnsellbillcurr->visaPayedC);
		$sqlQuery->set($returnsellbillcurr->extraDiscountValC);
		$sqlQuery->set($returnsellbillcurr->taxOfDiscountValC);
		$sqlQuery->set($returnsellbillcurr->saveConversionFactor);

		$id = $this->executeInsert($sqlQuery);	
		$returnsellbillcurr->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param ReturnsellbillcurrMySql returnsellbillcurr
 	 */
	public function update($returnsellbillcurr){
		$sql = 'UPDATE returnsellbillcurr SET returnsellbillid = ?, conversionFactor = ?, returnsellbilldiscountC = ?, returnsellbilltotalbillC = ?, returnsellbillaftertotalbillC = ?, returnsellbilltotalpayedC = ?, returnsellbillfinalbillC = ?, returnsellbildirectpaymentC = ?, taxC = ?, cashPayedC = ?, visaPayedC = ?, extraDiscountValC = ?, taxOfDiscountValC = ?, saveConversionFactor = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($returnsellbillcurr->returnsellbillid);
		$sqlQuery->set($returnsellbillcurr->conversionFactor);
		$sqlQuery->set($returnsellbillcurr->returnsellbilldiscountC);
		$sqlQuery->set($returnsellbillcurr->returnsellbilltotalbillC);
		$sqlQuery->set($returnsellbillcurr->returnsellbillaftertotalbillC);
		$sqlQuery->set($returnsellbillcurr->returnsellbilltotalpayedC);
		$sqlQuery->set($returnsellbillcurr->returnsellbillfinalbillC);
		$sqlQuery->setNumber($returnsellbillcurr->returnsellbildirectpaymentC);
		$sqlQuery->set($returnsellbillcurr->taxC);
		$sqlQuery->set($returnsellbillcurr->cashPayedC);
		$sqlQuery->set($returnsellbillcurr->visaPayedC);
		$sqlQuery->set($returnsellbillcurr->extraDiscountValC);
		$sqlQuery->set($returnsellbillcurr->taxOfDiscountValC);
		$sqlQuery->set($returnsellbillcurr->saveConversionFactor);

		$sqlQuery->setNumber($returnsellbillcurr->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM returnsellbillcurr';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByReturnsellbillid($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE returnsellbillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConversionFactor($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnsellbilldiscountC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE returnsellbilldiscountC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnsellbilltotalbillC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE returnsellbilltotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnsellbillaftertotalbillC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE returnsellbillaftertotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnsellbilltotalpayedC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE returnsellbilltotalpayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnsellbillfinalbillC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE returnsellbillfinalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnsellbildirectpaymentC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE returnsellbildirectpaymentC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTaxC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE taxC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCashPayedC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE cashPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByVisaPayedC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE visaPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByExtraDiscountValC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE extraDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTaxOfDiscountValC($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE taxOfDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySaveConversionFactor($value){
		$sql = 'SELECT * FROM returnsellbillcurr WHERE saveConversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByReturnsellbillid($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE returnsellbillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConversionFactor($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnsellbilldiscountC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE returnsellbilldiscountC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnsellbilltotalbillC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE returnsellbilltotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnsellbillaftertotalbillC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE returnsellbillaftertotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnsellbilltotalpayedC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE returnsellbilltotalpayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnsellbillfinalbillC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE returnsellbillfinalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnsellbildirectpaymentC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE returnsellbildirectpaymentC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTaxC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE taxC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCashPayedC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE cashPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByVisaPayedC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE visaPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByExtraDiscountValC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE extraDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTaxOfDiscountValC($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE taxOfDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySaveConversionFactor($value){
		$sql = 'DELETE FROM returnsellbillcurr WHERE saveConversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return ReturnsellbillcurrMySql 
	 */
	protected function readRow($row){
		$returnsellbillcurr = new Returnsellbillcurr();
		
		$returnsellbillcurr->id = $row['id'];
		$returnsellbillcurr->returnsellbillid = $row['returnsellbillid'];
		$returnsellbillcurr->conversionFactor = $row['conversionFactor'];
		$returnsellbillcurr->returnsellbilldiscountC = $row['returnsellbilldiscountC'];
		$returnsellbillcurr->returnsellbilltotalbillC = $row['returnsellbilltotalbillC'];
		$returnsellbillcurr->returnsellbillaftertotalbillC = $row['returnsellbillaftertotalbillC'];
		$returnsellbillcurr->returnsellbilltotalpayedC = $row['returnsellbilltotalpayedC'];
		$returnsellbillcurr->returnsellbillfinalbillC = $row['returnsellbillfinalbillC'];
		$returnsellbillcurr->returnsellbildirectpaymentC = $row['returnsellbildirectpaymentC'];
		$returnsellbillcurr->taxC = $row['taxC'];
		$returnsellbillcurr->cashPayedC = $row['cashPayedC'];
		$returnsellbillcurr->visaPayedC = $row['visaPayedC'];
		$returnsellbillcurr->extraDiscountValC = $row['extraDiscountValC'];
		$returnsellbillcurr->taxOfDiscountValC = $row['taxOfDiscountValC'];
		$returnsellbillcurr->saveConversionFactor = $row['saveConversionFactor'];

		return $returnsellbillcurr;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return ReturnsellbillcurrMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>