<?php

/**
 * Class that operate on table 'returnsellbilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ReturnsellbilldetailMySqlDAO implements ReturnsellbilldetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ReturnsellbilldetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE returnsellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM returnsellbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM returnsellbilldetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param returnsellbilldetail primary key
     */
    public function delete($returnsellbilldetailid) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE returnsellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($returnsellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ReturnsellbilldetailMySql returnsellbilldetail
     */
    public function insert($returnsellbilldetail) {
        $sql = 'INSERT INTO returnsellbilldetail (buyprice, parcode, returnsellbillid, returnsellbilldetailcatid, '
                . 'returnsellbilldetailproductid, returnsellbilldetailquantity, returnsellbilldetailprice,'
                . ' returnsellbilldetailtotalprice, conditions, note, pricetype, discountvalue, productunitid,'
                . ' buydiscount, buydiscounttype,storeid,discounttype,lastbuyprice,meanbuyprice,lastbuyprice_withDiscount,meanbuyprice_withDiscount,otherdetailquantity,sizeid,colorid,pricetypepro,proHeight,proWidth,soldSerialsInDetails,'
                . 'lastbuyprice_withTax,meanbuyprice_withTax,returnsellbilldetailpriceC,returnsellbilldetailtotalpriceC,discountvalueC,proSellTrackingSerial,lastbuyprice_withDiscountAndTax) '
                . 'VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($returnsellbilldetail->buyprice);
        $sqlQuery->set($returnsellbilldetail->parcode);
        $sqlQuery->setNumber($returnsellbilldetail->returnsellbillid);
        $sqlQuery->setNumber($returnsellbilldetail->returnsellbilldetailcatid);
        $sqlQuery->setNumber($returnsellbilldetail->returnsellbilldetailproductid);
        $sqlQuery->setNumber($returnsellbilldetail->returnsellbilldetailquantity);
        $sqlQuery->set($returnsellbilldetail->returnsellbilldetailprice);
        $sqlQuery->set($returnsellbilldetail->returnsellbilldetailtotalprice);
        $sqlQuery->set($returnsellbilldetail->conditions);
        $sqlQuery->set($returnsellbilldetail->note);
        $sqlQuery->setNumber($returnsellbilldetail->pricetype);
        $sqlQuery->set($returnsellbilldetail->discountvalue);
        $sqlQuery->setNumber($returnsellbilldetail->productunitid);
        $sqlQuery->setNumber($returnsellbilldetail->buydiscount);
        $sqlQuery->setNumber($returnsellbilldetail->buydiscounttype);
        $sqlQuery->setNumber($returnsellbilldetail->storeid);
        $sqlQuery->set($returnsellbilldetail->discounttype);
        $sqlQuery->set($returnsellbilldetail->lastbuyprice);
        $sqlQuery->set($returnsellbilldetail->meanbuyprice);
        $sqlQuery->set((float) $returnsellbilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $returnsellbilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber($returnsellbilldetail->otherdetailquantity);
        $sqlQuery->setNumber((int) $returnsellbilldetail->sizeid);
        $sqlQuery->setNumber((int) $returnsellbilldetail->colorid);
        $sqlQuery->setNumber((int) $returnsellbilldetail->pricetypepro);
        $sqlQuery->setNumber((float) $returnsellbilldetail->proHeight);
        $sqlQuery->setNumber((float) $returnsellbilldetail->proWidth);
        $sqlQuery->set($returnsellbilldetail->soldSerialsInDetails);
        $sqlQuery->setNumber((float) $returnsellbilldetail->lastbuyprice_withTax);
        $sqlQuery->setNumber((float) $returnsellbilldetail->meanbuyprice_withTax);
        $sqlQuery->setNumber((float) $returnsellbilldetail->returnsellbilldetailpriceC);
        $sqlQuery->setNumber((float) $returnsellbilldetail->returnsellbilldetailtotalpriceC);
        $sqlQuery->setNumber((float) $returnsellbilldetail->discountvalueC);
        $sqlQuery->set($returnsellbilldetail->proSellTrackingSerial);
        $sqlQuery->setNumber((float) $returnsellbilldetail->lastbuyprice_withDiscountAndTax);



        $id = $this->executeInsert($sqlQuery);
        $returnsellbilldetail->returnsellbilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ReturnsellbilldetailMySql returnsellbilldetail
     */
    public function update($returnsellbilldetail) {
        $sql = 'UPDATE returnsellbilldetail SET buyprice = ?, parcode = ?, returnsellbillid = ?, returnsellbilldetailcatid = ?, returnsellbilldetailproductid = ?, returnsellbilldetailquantity = ?, returnsellbilldetailprice = ?, returnsellbilldetailtotalprice = ?, conditions = ?, note = ?, pricetype = ?, discountvalue = ?, productunitid = ?, buydiscount = ?, buydiscounttype = ? ,storeid =?,lastbuyprice = ?,meanbuyprice = ?,lastbuyprice_withDiscount = ?,meanbuyprice_withDiscount = ?,sizeid = ?,colorid = ?,pricetypepro = ?,proHeight=?,proWidth=?,soldSerialsInDetails=?,lastbuyprice_withTax=?,meanbuyprice_withTax=?,returnsellbilldetailpriceC=?,returnsellbilldetailtotalpriceC=?,discountvalueC=?,proSellTrackingSerial=?,lastbuyprice_withDiscountAndTax=?  WHERE returnsellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($returnsellbilldetail->buyprice);
        $sqlQuery->set($returnsellbilldetail->parcode);
        $sqlQuery->setNumber($returnsellbilldetail->returnsellbillid);
        $sqlQuery->setNumber($returnsellbilldetail->returnsellbilldetailcatid);
        $sqlQuery->setNumber($returnsellbilldetail->returnsellbilldetailproductid);
        $sqlQuery->setNumber($returnsellbilldetail->returnsellbilldetailquantity);
        $sqlQuery->set($returnsellbilldetail->returnsellbilldetailprice);
        $sqlQuery->set($returnsellbilldetail->returnsellbilldetailtotalprice);
        $sqlQuery->set($returnsellbilldetail->conditions);
        $sqlQuery->set($returnsellbilldetail->note);
        $sqlQuery->setNumber($returnsellbilldetail->pricetype);
        $sqlQuery->set($returnsellbilldetail->discountvalue);
        $sqlQuery->setNumber($returnsellbilldetail->productunitid);
        $sqlQuery->setNumber($returnsellbilldetail->buydiscount);
        $sqlQuery->setNumber($returnsellbilldetail->buydiscounttype);
        $sqlQuery->setNumber($returnsellbilldetail->storeid);
        $sqlQuery->set($returnsellbilldetail->lastbuyprice);
        $sqlQuery->set($returnsellbilldetail->meanbuyprice);
        $sqlQuery->set((float) $returnsellbilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $returnsellbilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber((int) $returnsellbilldetail->sizeid);
        $sqlQuery->setNumber((int) $returnsellbilldetail->colorid);
        $sqlQuery->setNumber((int) $returnsellbilldetail->pricetypepro);
        $sqlQuery->setNumber((float) $returnsellbilldetail->proHeight);
        $sqlQuery->setNumber((float) $returnsellbilldetail->proWidth);
        $sqlQuery->set($returnsellbilldetail->soldSerialsInDetails);
        $sqlQuery->setNumber((float) $returnsellbilldetail->lastbuyprice_withTax);
        $sqlQuery->setNumber((float) $returnsellbilldetail->meanbuyprice_withTax);
        $sqlQuery->setNumber((float) $returnsellbilldetail->returnsellbilldetailpriceC);
        $sqlQuery->setNumber((float) $returnsellbilldetail->returnsellbilldetailtotalpriceC);
        $sqlQuery->setNumber((float) $returnsellbilldetail->discountvalueC);
        $sqlQuery->set($returnsellbilldetail->proSellTrackingSerial);
        $sqlQuery->setNumber((float) $returnsellbilldetail->lastbuyprice_withDiscountAndTax);

        $sqlQuery->setNumber($returnsellbilldetail->returnsellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM returnsellbilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuyprice($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbillid($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE returnsellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldetailcatid($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE returnsellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldetailproductid($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE returnsellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldetailquantity($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE returnsellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldetailprice($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE returnsellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnsellbilldetailtotalprice($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE returnsellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPricetype($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM returnsellbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuyprice($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbillid($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE returnsellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldetailcatid($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE returnsellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldetailproductid($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE returnsellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldetailquantity($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE returnsellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldetailprice($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE returnsellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnsellbilldetailtotalprice($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE returnsellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPricetype($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM returnsellbilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ReturnsellbilldetailMySql
     */
    protected function readRow($row) {
        $returnsellbilldetail = new Returnsellbilldetail();

        $returnsellbilldetail->returnsellbilldetailid = isset($row['returnsellbilldetailid']) ? $row['returnsellbilldetailid'] : '';
        $returnsellbilldetail->buyprice = isset($row['buyprice']) ? $row['buyprice'] : '';
        $returnsellbilldetail->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $returnsellbilldetail->returnsellbillid = isset($row['returnsellbillid']) ? $row['returnsellbillid'] : '';
        $returnsellbilldetail->returnsellbilldetailcatid = isset($row['returnsellbilldetailcatid']) ? $row['returnsellbilldetailcatid'] : '';
        $returnsellbilldetail->returnsellbilldetailproductid = isset($row['returnsellbilldetailproductid']) ? $row['returnsellbilldetailproductid'] : '';
        $returnsellbilldetail->returnsellbilldetailquantity = isset($row['returnsellbilldetailquantity']) ? $row['returnsellbilldetailquantity'] : '';
        $returnsellbilldetail->returnsellbilldetailprice = isset($row['returnsellbilldetailprice']) ? $row['returnsellbilldetailprice'] : '';
        $returnsellbilldetail->returnsellbilldetailtotalprice = isset($row['returnsellbilldetailtotalprice']) ? $row['returnsellbilldetailtotalprice'] : '';
        $returnsellbilldetail->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $returnsellbilldetail->note = isset($row['note']) ? $row['note'] : '';
        $returnsellbilldetail->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $returnsellbilldetail->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $returnsellbilldetail->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';
        $returnsellbilldetail->buydiscount = isset($row['buydiscount']) ? $row['buydiscount'] : '';
        $returnsellbilldetail->buydiscounttype = isset($row['buydiscounttype']) ? $row['buydiscounttype'] : '';
        $returnsellbilldetail->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $returnsellbilldetail->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';

        $returnsellbilldetail->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $returnsellbilldetail->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $returnsellbilldetail->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';
        $returnsellbilldetail->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $returnsellbilldetail->lastbuyprice_withTax = isset($row['lastbuyprice_withTax']) ? $row['lastbuyprice_withTax'] : '';
        $returnsellbilldetail->meanbuyprice_withTax = isset($row['meanbuyprice_withTax']) ? $row['meanbuyprice_withTax'] : '';
        $returnsellbilldetail->returnsellbilldetailpriceC = isset($row['returnsellbilldetailpriceC']) ? $row['returnsellbilldetailpriceC'] : '';
        $returnsellbilldetail->returnsellbilldetailtotalpriceC = isset($row['returnsellbilldetailtotalpriceC']) ? $row['returnsellbilldetailtotalpriceC'] : '';
        $returnsellbilldetail->discountvalueC = isset($row['discountvalueC']) ? $row['discountvalueC'] : '';
        $returnsellbilldetail->proSellTrackingSerial = isset($row['proSellTrackingSerial']) ? $row['proSellTrackingSerial'] : '';
        $returnsellbilldetail->lastbuyprice_withDiscountAndTax = isset($row['lastbuyprice_withDiscountAndTax']) ? $row['lastbuyprice_withDiscountAndTax'] : '';

        $returnsellbilldetail->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $returnsellbilldetail->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $returnsellbilldetail->pricetypepro = isset($row['pricetypepro']) ? $row['pricetypepro'] : '';
        //required
        $returnsellbilldetail->productName = isset($row['productName']) ? $row['productName'] : '';
        $returnsellbilldetail->unitName = isset($row['unitName']) ? $row['unitName'] : '';
        $returnsellbilldetail->unitid = isset($row['unitid']) ? $row['unitid'] : '';
        $returnsellbilldetail->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';
        $returnsellbilldetail->sumQuantity = isset($row['sumQuantity']) ? $row['sumQuantity'] : '';
        $returnsellbilldetail->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $returnsellbilldetail->returnsellbilldate = isset($row['returnsellbilldate']) ? $row['returnsellbilldate'] : '';

        $returnsellbilldetail->returnsellbilltotalbill = isset($row['returnsellbilltotalbill']) ? $row['returnsellbilltotalbill'] : '';
        $returnsellbilldetail->returnsellbilldiscount = isset($row['returnsellbilldiscount']) ? $row['returnsellbilldiscount'] : '';
        $returnsellbilldetail->returnsellbilldiscounttype = isset($row['returnsellbilldiscounttype']) ? $row['returnsellbilldiscounttype'] : '';
        $returnsellbilldetail->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $returnsellbilldetail->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $returnsellbilldetail->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $returnsellbilldetail->otherdetailquantity = isset($row['otherdetailquantity']) ? $row['otherdetailquantity'] : '';
        $returnsellbilldetail->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';

        $returnsellbilldetail->userid = isset($row['userid']) ? $row['userid'] : '';
        $returnsellbilldetail->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $returnsellbilldetail->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $returnsellbilldetail->generalPrice = isset($row['generalPrice']) ? $row['generalPrice'] : '';
        $returnsellbilldetail->productserailid = isset($row['productserailid']) ? $row['productserailid'] : '';
        $returnsellbilldetail->don = isset($row['don']) ? $row['don'] : '';
        $returnsellbilldetail->proHeight = isset($row['proHeight']) ? $row['proHeight'] : '';
        $returnsellbilldetail->proWidth = isset($row['proWidth']) ? $row['proWidth'] : '';
        $returnsellbilldetail->soldSerialsInDetails = isset($row['soldSerialsInDetails']) ? $row['soldSerialsInDetails'] : '';

        return $returnsellbilldetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ReturnsellbilldetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>