<?php

/**
 * Class that operate on table 'sellbillandruterncurr'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-03-08 08:37
 */
class SellbillandruterncurrMySqlDAO implements SellbillandruterncurrDAO
{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return SellbillandruterncurrMySql 
	 */
	public function load($id)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll()
	{
		$sql = 'SELECT * FROM sellbillandruterncurr';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}

	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr ORDER BY ' . $orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}

	/**
	 * Delete record from table
	 * @param sellbillandruterncurr primary key
	 */
	public function delete($id)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
	 * Insert record to table
	 *
	 * @param SellbillandruterncurrMySql sellbillandruterncurr
	 */
	public function insert($sellbillandruterncurr)
	{
		$sql = 'INSERT INTO sellbillandruterncurr (sellbillid, conversionFactor, sellbilldiscountC, sellbilltotalbillC, sellbillaftertotalbillC, sellbilltotalpayedC, sellbillfinalbillC, sellbildirectpaymentC, sellbillpriceC, returnsellbillpriceC, taxC, cashPayedC, visaPayedC, extraDiscountValC, taxOfDiscountValC, saveConversionFactor,totalprodiscountC) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
		$sqlQuery = new SqlQuery($sql);

		$sqlQuery->setNumber($sellbillandruterncurr->sellbillid);
		$sqlQuery->set($sellbillandruterncurr->conversionFactor);
		$sqlQuery->set($sellbillandruterncurr->sellbilldiscountC);
		$sqlQuery->set($sellbillandruterncurr->sellbilltotalbillC);
		$sqlQuery->set($sellbillandruterncurr->sellbillaftertotalbillC);
		$sqlQuery->set($sellbillandruterncurr->sellbilltotalpayedC);
		$sqlQuery->set($sellbillandruterncurr->sellbillfinalbillC);
		$sqlQuery->setNumber($sellbillandruterncurr->sellbildirectpaymentC);
		$sqlQuery->set($sellbillandruterncurr->sellbillpriceC);
		$sqlQuery->set($sellbillandruterncurr->returnsellbillpriceC);
		$sqlQuery->set($sellbillandruterncurr->taxC);
		$sqlQuery->set($sellbillandruterncurr->cashPayedC);
		$sqlQuery->set($sellbillandruterncurr->visaPayedC);
		$sqlQuery->set($sellbillandruterncurr->extraDiscountValC);
		$sqlQuery->set($sellbillandruterncurr->taxOfDiscountValC);
		$sqlQuery->set($sellbillandruterncurr->saveConversionFactor);
		$sqlQuery->set($sellbillandruterncurr->totalprodiscountC);

		$id = $this->executeInsert($sqlQuery);
		$sellbillandruterncurr->id = $id;
		return $id;
	}

	/**
	 * Update record in table
	 *
	 * @param SellbillandruterncurrMySql sellbillandruterncurr
	 */
	public function update($sellbillandruterncurr)
	{
		$sql = 'UPDATE sellbillandruterncurr SET sellbillid = ?, conversionFactor = ?, sellbilldiscountC = ?, sellbilltotalbillC = ?, sellbillaftertotalbillC = ?, sellbilltotalpayedC = ?, sellbillfinalbillC = ?, sellbildirectpaymentC = ?, sellbillpriceC = ?, returnsellbillpriceC = ?, taxC = ?, cashPayedC = ?, visaPayedC = ?, extraDiscountValC = ?, taxOfDiscountValC = ?, saveConversionFactor = ?, totalprodiscountC=? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);

		$sqlQuery->setNumber($sellbillandruterncurr->sellbillid);
		$sqlQuery->set($sellbillandruterncurr->conversionFactor);
		$sqlQuery->set($sellbillandruterncurr->sellbilldiscountC);
		$sqlQuery->set($sellbillandruterncurr->sellbilltotalbillC);
		$sqlQuery->set($sellbillandruterncurr->sellbillaftertotalbillC);
		$sqlQuery->set($sellbillandruterncurr->sellbilltotalpayedC);
		$sqlQuery->set($sellbillandruterncurr->sellbillfinalbillC);
		$sqlQuery->setNumber($sellbillandruterncurr->sellbildirectpaymentC);
		$sqlQuery->set($sellbillandruterncurr->sellbillpriceC);
		$sqlQuery->set($sellbillandruterncurr->returnsellbillpriceC);
		$sqlQuery->set($sellbillandruterncurr->taxC);
		$sqlQuery->set($sellbillandruterncurr->cashPayedC);
		$sqlQuery->set($sellbillandruterncurr->visaPayedC);
		$sqlQuery->set($sellbillandruterncurr->extraDiscountValC);
		$sqlQuery->set($sellbillandruterncurr->taxOfDiscountValC);
		$sqlQuery->set($sellbillandruterncurr->saveConversionFactor);
		$sqlQuery->set($sellbillandruterncurr->totalprodiscountC);

		$sqlQuery->setNumber($sellbillandruterncurr->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
	 * Delete all rows
	 */
	public function clean()
	{
		$sql = 'DELETE FROM sellbillandruterncurr';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySellbillid($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE sellbillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConversionFactor($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbilldiscountC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE sellbilldiscountC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbilltotalbillC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE sellbilltotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbillaftertotalbillC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE sellbillaftertotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbilltotalpayedC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE sellbilltotalpayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbillfinalbillC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE sellbillfinalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbildirectpaymentC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE sellbildirectpaymentC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbillpriceC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE sellbillpriceC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByReturnsellbillpriceC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE returnsellbillpriceC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTaxC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE taxC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCashPayedC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE cashPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByVisaPayedC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE visaPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByExtraDiscountValC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE extraDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTaxOfDiscountValC($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE taxOfDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySaveConversionFactor($value)
	{
		$sql = 'SELECT * FROM sellbillandruterncurr WHERE saveConversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySellbillid($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE sellbillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConversionFactor($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbilldiscountC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE sellbilldiscountC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbilltotalbillC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE sellbilltotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbillaftertotalbillC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE sellbillaftertotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbilltotalpayedC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE sellbilltotalpayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbillfinalbillC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE sellbillfinalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbildirectpaymentC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE sellbildirectpaymentC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbillpriceC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE sellbillpriceC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByReturnsellbillpriceC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE returnsellbillpriceC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTaxC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE taxC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCashPayedC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE cashPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByVisaPayedC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE visaPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByExtraDiscountValC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE extraDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTaxOfDiscountValC($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE taxOfDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySaveConversionFactor($value)
	{
		$sql = 'DELETE FROM sellbillandruterncurr WHERE saveConversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}



	/**
	 * Read row
	 *
	 * @return SellbillandruterncurrMySql 
	 */
	protected function readRow($row)
	{
		$sellbillandruterncurr = new Sellbillandruterncurr();

		$sellbillandruterncurr->id = $row['id'];
		$sellbillandruterncurr->sellbillid = $row['sellbillid'];
		$sellbillandruterncurr->conversionFactor = $row['conversionFactor'];
		$sellbillandruterncurr->sellbilldiscountC = $row['sellbilldiscountC'];
		$sellbillandruterncurr->sellbilltotalbillC = $row['sellbilltotalbillC'];
		$sellbillandruterncurr->sellbillaftertotalbillC = $row['sellbillaftertotalbillC'];
		$sellbillandruterncurr->sellbilltotalpayedC = $row['sellbilltotalpayedC'];
		$sellbillandruterncurr->sellbillfinalbillC = $row['sellbillfinalbillC'];
		$sellbillandruterncurr->sellbildirectpaymentC = $row['sellbildirectpaymentC'];
		$sellbillandruterncurr->sellbillpriceC = $row['sellbillpriceC'];
		$sellbillandruterncurr->returnsellbillpriceC = $row['returnsellbillpriceC'];
		$sellbillandruterncurr->taxC = $row['taxC'];
		$sellbillandruterncurr->cashPayedC = $row['cashPayedC'];
		$sellbillandruterncurr->visaPayedC = $row['visaPayedC'];
		$sellbillandruterncurr->extraDiscountValC = $row['extraDiscountValC'];
		$sellbillandruterncurr->taxOfDiscountValC = $row['taxOfDiscountValC'];
		$sellbillandruterncurr->saveConversionFactor = $row['saveConversionFactor'];
		$sellbillandruterncurr->totalprodiscountC = $row['totalprodiscountC'];

		return $sellbillandruterncurr;
	}

	protected function getList($sqlQuery)
	{
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for ($i = 0; $i < count($tab); $i++) {
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}

	/**
	 * Get row
	 *
	 * @return SellbillandruterncurrMySql 
	 */
	protected function getRow($sqlQuery)
	{
		$tab = QueryExecutor::execute($sqlQuery);
		if (count($tab) == 0) {
			return null;
		}
		return $this->readRow($tab[0]);
	}

	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery)
	{
		return QueryExecutor::execute($sqlQuery);
	}


	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery)
	{
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery)
	{
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery)
	{
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
