<?php

/**
 * Class that operate on table 'sellbillorder'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-05 16:27
 */
class SellbillorderMySqlDAO implements SellbillorderDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SellbillorderMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sellbillorder';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sellbillorder ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sellbillorder primary key
     */
    public function delete($sellbillid) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SellbillorderMySql sellbillorder
     */
    public function insert($sellbillorder) {
        $sql = 'INSERT INTO sellbillorder (sellbilldate, sellbillserial, sellbillclientid, sellbilltotaldeptbefor, sellbilltotaldeptafter, sellbilldiscount, sellbilldiscounttype, sellbilltotalbill, sellbillaftertotalbill, sellbilltotalpayed, sellbillfinalbill, sellbillstoreid, sellbillsysdate, userid, conditions, sellbillclientname, sellbillsaveid, sellbildirectpayment, billnameid, sellerid, tempclientName, sellQuantity, actualsellbill, saveAffect) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbillorder->sellbilldate);
        $sqlQuery->set($sellbillorder->sellbillserial);
        $sqlQuery->setNumber($sellbillorder->sellbillclientid);
        $sqlQuery->set($sellbillorder->sellbilltotaldeptbefor);
        $sqlQuery->set($sellbillorder->sellbilltotaldeptafter);
        $sqlQuery->set($sellbillorder->sellbilldiscount);
        $sqlQuery->setNumber($sellbillorder->sellbilldiscounttype);
        $sqlQuery->set($sellbillorder->sellbilltotalbill);
        $sqlQuery->set($sellbillorder->sellbillaftertotalbill);
        $sqlQuery->set($sellbillorder->sellbilltotalpayed);
        $sqlQuery->set($sellbillorder->sellbillfinalbill);
        $sqlQuery->setNumber($sellbillorder->sellbillstoreid);
        $sqlQuery->set($sellbillorder->sellbillsysdate);
        $sqlQuery->setNumber($sellbillorder->userid);
        $sqlQuery->setNumber($sellbillorder->conditions);
        $sqlQuery->setString2($sellbillorder->sellbillclientname);
        $sqlQuery->setNumber($sellbillorder->sellbillsaveid);
        $sqlQuery->setNumber($sellbillorder->sellbildirectpayment);
        $sqlQuery->setNumber($sellbillorder->billnameid);
        $sqlQuery->setNumber($sellbillorder->sellerid);
        $sqlQuery->set($sellbillorder->tempclientName);
        $sqlQuery->set($sellbillorder->sellQuantity);
        $sqlQuery->setNumber($sellbillorder->actualsellbill);
        $sqlQuery->setNumber($sellbillorder->saveAffect);

        $id = $this->executeInsert($sqlQuery);
        $sellbillorder->sellbillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SellbillorderMySql sellbillorder
     */
    public function update($sellbillorder) {
        $sql = 'UPDATE sellbillorder SET sellbilldate = ?, sellbillserial = ?, sellbillclientid = ?, sellbilltotaldeptbefor = ?, sellbilltotaldeptafter = ?, sellbilldiscount = ?, sellbilldiscounttype = ?, sellbilltotalbill = ?, sellbillaftertotalbill = ?, sellbilltotalpayed = ?, sellbillfinalbill = ?, sellbillstoreid = ?, sellbillsysdate = ?, userid = ?, conditions = ?, sellbillclientname = ?, sellbillsaveid = ?, sellbildirectpayment = ?, billnameid = ?, sellerid = ?, tempclientName = ?, sellQuantity = ?, actualsellbill = ?, saveAffect = ? WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbillorder->sellbilldate);
        $sqlQuery->set($sellbillorder->sellbillserial);
        $sqlQuery->setNumber($sellbillorder->sellbillclientid);
        $sqlQuery->set($sellbillorder->sellbilltotaldeptbefor);
        $sqlQuery->set($sellbillorder->sellbilltotaldeptafter);
        $sqlQuery->set($sellbillorder->sellbilldiscount);
        $sqlQuery->setNumber($sellbillorder->sellbilldiscounttype);
        $sqlQuery->set($sellbillorder->sellbilltotalbill);
        $sqlQuery->set($sellbillorder->sellbillaftertotalbill);
        $sqlQuery->set($sellbillorder->sellbilltotalpayed);
        $sqlQuery->set($sellbillorder->sellbillfinalbill);
        $sqlQuery->setNumber($sellbillorder->sellbillstoreid);
        $sqlQuery->set($sellbillorder->sellbillsysdate);
        $sqlQuery->setNumber($sellbillorder->userid);
        $sqlQuery->setNumber($sellbillorder->conditions);
        $sqlQuery->setString2($sellbillorder->sellbillclientname);
        $sqlQuery->setNumber($sellbillorder->sellbillsaveid);
        $sqlQuery->setNumber($sellbillorder->sellbildirectpayment);
        $sqlQuery->setNumber($sellbillorder->billnameid);
        $sqlQuery->setNumber($sellbillorder->sellerid);
        $sqlQuery->set($sellbillorder->tempclientName);
        $sqlQuery->set($sellbillorder->sellQuantity);
        $sqlQuery->setNumber($sellbillorder->actualsellbill);
        $sqlQuery->setNumber($sellbillorder->saveAffect);

        $sqlQuery->setNumber($sellbillorder->sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sellbillorder';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySellbilldate($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillserial($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientid($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptafter($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscount($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscounttype($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalbill($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillaftertotalbill($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalpayed($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillfinalbill($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillstoreid($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsysdate($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientname($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsaveid($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbildirectpayment($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellerid($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempclientName($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellQuantity($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE sellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByActualsellbill($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE actualsellbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveAffect($value) {
        $sql = 'SELECT * FROM sellbillorder WHERE saveAffect = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySellbilldate($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillserial($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientid($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptbefor($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptafter($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscount($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscounttype($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalbill($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillaftertotalbill($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalpayed($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillfinalbill($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillstoreid($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsysdate($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM sellbillorder WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM sellbillorder WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientname($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsaveid($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbildirectpayment($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM sellbillorder WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellerid($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempclientName($value) {
        $sql = 'DELETE FROM sellbillorder WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellQuantity($value) {
        $sql = 'DELETE FROM sellbillorder WHERE sellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByActualsellbill($value) {
        $sql = 'DELETE FROM sellbillorder WHERE actualsellbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveAffect($value) {
        $sql = 'DELETE FROM sellbillorder WHERE saveAffect = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SellbillorderMySql
     */
    protected function readRow($row) {
        $sellbillorder = new Sellbillorder();

        $sellbillorder->sellbillid = isset($row['']) ? $row[''] : '';
        $sellbillorder->sellbilldate = isset($row['sellbilldate']) ? $row['sellbilldate'] : '';
        $sellbillorder->sellbillserial = isset($row['sellbillserial']) ? $row['sellbillserial'] : '';
        $sellbillorder->sellbillclientid = isset($row['sellbillclientid']) ? $row['sellbillclientid'] : '';
        $sellbillorder->sellbilltotaldeptbefor = isset($row['sellbilltotaldeptbefor']) ? $row['sellbilltotaldeptbefor'] : '';
        $sellbillorder->sellbilltotaldeptafter = isset($row['sellbilltotaldeptafter']) ? $row['sellbilltotaldeptafter'] : '';
        $sellbillorder->sellbilldiscount = isset($row['sellbilldiscount']) ? $row['sellbilldiscount'] : '';
        $sellbillorder->sellbilldiscounttype = isset($row['sellbilldiscounttype']) ? $row['sellbilldiscounttype'] : '';
        $sellbillorder->sellbilltotalbill = isset($row['sellbilltotalbill']) ? $row['sellbilltotalbill'] : '';
        $sellbillorder->sellbillaftertotalbill = isset($row['sellbillaftertotalbill']) ? $row['sellbillaftertotalbill'] : '';
        $sellbillorder->sellbilltotalpayed = isset($row['sellbilltotalpayed']) ? $row['sellbilltotalpayed'] : '';
        $sellbillorder->sellbillfinalbill = isset($row['sellbillfinalbill']) ? $row['sellbillfinalbill'] : '';
        $sellbillorder->sellbillstoreid = isset($row['sellbillstoreid']) ? $row['sellbillstoreid'] : '';
        $sellbillorder->sellbillsysdate = isset($row['sellbillsysdate']) ? $row['sellbillsysdate'] : '';
        $sellbillorder->userid = isset($row['userid']) ? $row['userid'] : '';
        $sellbillorder->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $sellbillorder->sellbillclientname = isset($row['sellbillclientname']) ? $row['sellbillclientname'] : '';
        $sellbillorder->sellbillsaveid = isset($row['sellbillsaveid']) ? $row['sellbillsaveid'] : '';
        $sellbillorder->sellbildirectpayment = isset($row['sellbildirectpayment']) ? $row['sellbildirectpayment'] : '';
        $sellbillorder->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $sellbillorder->sellerid = isset($row['sellerid']) ? $row['sellerid'] : '';
        $sellbillorder->tempclientName = isset($row['tempclientName']) ? $row['tempclientName'] : '';
        $sellbillorder->sellQuantity = isset($row['sellQuantity']) ? $row['sellQuantity'] : '';
        $sellbillorder->actualsellbill = isset($row['actualsellbill']) ? $row['actualsellbill'] : '';
        $sellbillorder->saveAffect = isset($row['saveAffect']) ? $row['saveAffect'] : '';

        return $sellbillorder;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SellbillorderMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>