<?php

/**
 * Class that operate on table 'slider'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2025-05-13 00:18
 */
class SliderMySqlDAO implements SliderDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SliderMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM slider WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM slider';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM slider ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param slider primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM slider WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SliderMySql slider
     */
    public function insert($slider) {
        $sql = 'INSERT INTO slider (title, titleEn, titleUrl, openTarget, mediaUrl, mediaType, description, descriptionEn, position, isActive, sysDate, userid, isdel) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($slider->title);
        $sqlQuery->set($slider->titleEn);
        $sqlQuery->set($slider->titleUrl);
        $sqlQuery->setNumber($slider->openTarget);
        $sqlQuery->set($slider->mediaUrl);
        $sqlQuery->setNumber($slider->mediaType);
        $sqlQuery->setString2($slider->description);
        $sqlQuery->setString2($slider->descriptionEn);
        $sqlQuery->setNumber((int) $slider->position);
        $sqlQuery->setNumber($slider->isActive);
        $sqlQuery->set($slider->sysDate);
        $sqlQuery->setNumber($slider->userid);
        $sqlQuery->setNumber($slider->isdel);

        $id = $this->executeInsert($sqlQuery);
        $slider->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SliderMySql slider
     */
    public function update($slider) {
        $sql = 'UPDATE slider SET title = ?, titleEn = ?, titleUrl = ?, openTarget = ?, mediaUrl = ?, mediaType = ?, description = ?, descriptionEn = ?, position = ?, isActive = ?, sysDate = ?, userid = ?, isdel = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($slider->title);
        $sqlQuery->set($slider->titleEn);
        $sqlQuery->set($slider->titleUrl);
        $sqlQuery->setNumber($slider->openTarget);
        $sqlQuery->set($slider->mediaUrl);
        $sqlQuery->setNumber($slider->mediaType);
        $sqlQuery->setString2($slider->description);
        $sqlQuery->setString2($slider->descriptionEn);
        $sqlQuery->setNumber((int) $slider->position);
        $sqlQuery->setNumber($slider->isActive);
        $sqlQuery->set($slider->sysDate);
        $sqlQuery->setNumber($slider->userid);
        $sqlQuery->setNumber($slider->isdel);

        $sqlQuery->setNumber($slider->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM slider';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByTitle($value) {
        $sql = 'SELECT * FROM slider WHERE title = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTitleEn($value) {
        $sql = 'SELECT * FROM slider WHERE titleEn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTitleUrl($value) {
        $sql = 'SELECT * FROM slider WHERE titleUrl = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOpenTarget($value) {
        $sql = 'SELECT * FROM slider WHERE openTarget = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMediaUrl($value) {
        $sql = 'SELECT * FROM slider WHERE mediaUrl = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMediaType($value) {
        $sql = 'SELECT * FROM slider WHERE mediaType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDescription($value) {
        $sql = 'SELECT * FROM slider WHERE description = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDescriptionEn($value) {
        $sql = 'SELECT * FROM slider WHERE descriptionEn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPosition($value) {
        $sql = 'SELECT * FROM slider WHERE position = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsActive($value) {
        $sql = 'SELECT * FROM slider WHERE isActive = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysDate($value) {
        $sql = 'SELECT * FROM slider WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM slider WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIsdel($value) {
        $sql = 'SELECT * FROM slider WHERE isdel = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByTitle($value) {
        $sql = 'DELETE FROM slider WHERE title = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTitleEn($value) {
        $sql = 'DELETE FROM slider WHERE titleEn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTitleUrl($value) {
        $sql = 'DELETE FROM slider WHERE titleUrl = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOpenTarget($value) {
        $sql = 'DELETE FROM slider WHERE openTarget = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMediaUrl($value) {
        $sql = 'DELETE FROM slider WHERE mediaUrl = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMediaType($value) {
        $sql = 'DELETE FROM slider WHERE mediaType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDescription($value) {
        $sql = 'DELETE FROM slider WHERE description = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDescriptionEn($value) {
        $sql = 'DELETE FROM slider WHERE descriptionEn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPosition($value) {
        $sql = 'DELETE FROM slider WHERE position = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsActive($value) {
        $sql = 'DELETE FROM slider WHERE isActive = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysDate($value) {
        $sql = 'DELETE FROM slider WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM slider WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIsdel($value) {
        $sql = 'DELETE FROM slider WHERE isdel = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SliderMySql
     */
    protected function readRow($row) {
        $slider = new Slider();

        $slider->id = $row['id'];
        $slider->title = $row['title'];
        $slider->titleEn = $row['titleEn'];
        $slider->titleUrl = $row['titleUrl'];
        $slider->openTarget = $row['openTarget'];
        $slider->mediaUrl = $row['mediaUrl'];
        $slider->mediaType = $row['mediaType'];
        $slider->description = $row['description'];
        $slider->descriptionEn = $row['descriptionEn'];
        $slider->position = $row['position'];
        $slider->isActive = $row['isActive'];
        $slider->sysDate = $row['sysDate'];
        $slider->userid = $row['userid'];
        $slider->isdel = $row['isdel'];

        return $slider;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SliderMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>