<?php

/**
 * Class that operate on table 'store'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class StoreMySqlDAO implements StoreDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return StoreMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM store WHERE storeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll($queryString = '') {
        $sql = 'SELECT * FROM store where 1 ' . $queryString;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM store ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param store primary key
     */
    public function delete($storeId) {
        $sql = 'DELETE FROM store WHERE storeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($storeId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param StoreMySql store
     */
    public function insert($store, $storeDescription) {
        $sql = 'INSERT INTO store (storeName, nameEn, branchId, addressAr, addressEn, phone, email, storeDate, storeDescription, conditions, userId, treeId, treeIdBetween, webApiId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, "' . $storeDescription . '", ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($store->storeName);
        $sqlQuery->set($store->nameEn);
        $sqlQuery->setNumber((int)$store->branchId);
        $sqlQuery->set($store->addressAr);
        $sqlQuery->set($store->addressEn);
        $sqlQuery->set($store->phone);
        $sqlQuery->set($store->email);
        $sqlQuery->set($store->storeDate);
        //$sqlQuery->set($store->storeDescription);
        $sqlQuery->setNumber($store->conditions);
        $sqlQuery->setNumber($store->userId);
        $sqlQuery->setNumber((int) $store->treeId);
        $sqlQuery->setNumber((int) $store->treeIdBetween);
        $sqlQuery->setNumber((int) $store->webApiId);

        $id = $this->executeInsert($sqlQuery);
        $store->storeId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param StoreMySql store
     */
    public function update($store, $storeDescription) {
        $sql = 'UPDATE store SET storeName = ?, nameEn = ?, branchId = ?, addressAr = ?, addressEn = ?, phone = ?, email = ?, storeDate = ?, storeDescription = "' . $storeDescription . '", conditions = ?, userId = ?, treeId = ?, treeIdBetween = ?, updatedAt = CURRENT_TIMESTAMP WHERE storeId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($store->storeName);
        $sqlQuery->set($store->nameEn);
        $sqlQuery->setNumber((int)$store->branchId);
        $sqlQuery->set($store->addressAr);
        $sqlQuery->set($store->addressEn);
        $sqlQuery->set($store->phone);
        $sqlQuery->set($store->email);
        $sqlQuery->set($store->storeDate);
        //$sqlQuery->set($store->storeDescription);
        $sqlQuery->setNumber($store->conditions);
        $sqlQuery->setNumber($store->userId);
        $sqlQuery->setNumber((int) $store->treeId);
        $sqlQuery->setNumber((int) $store->treeIdBetween);

        $sqlQuery->setNumber($store->storeId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM store';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStoreName($value) {
        $sql = 'SELECT * FROM store WHERE storeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreDate($value) {
        $sql = 'SELECT * FROM store WHERE storeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreDescription($value) {
        $sql = 'SELECT * FROM store WHERE storeDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM store WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM store WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStoreName($value) {
        $sql = 'DELETE FROM store WHERE storeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreDate($value) {
        $sql = 'DELETE FROM store WHERE storeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreDescription($value) {
        $sql = 'DELETE FROM store WHERE storeDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM store WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM store WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return StoreMySql
     */
    protected function readRow($row) {
        $store = new Store();

        $store->storeId = $row['storeId'];
        $store->storeName = $row['storeName'];
        $store->nameEn = $row['nameEn'];
        $store->branchId = $row['branchId'];
        $store->addressAr = $row['addressAr'];
        $store->addressEn = $row['addressEn'];
        $store->phone = $row['phone'];
        $store->email = $row['email'];
        $store->storeDate = $row['storeDate'];
        $store->storeDescription = $row['storeDescription'];
        $store->conditions = $row['conditions'];
        $store->userId = $row['userId'];
        $store->treeId = $row['treeId'];
        $store->treeIdBetween = $row['treeIdBetween'];
        $store->webApiId = $row['webApiId'];
        $store->createdAt = $row['createdAt'];
        $store->updatedAt = $row['updatedAt'];

        $store->totQty = isset($row['totQty']) ? $row['totQty'] : '';
        $store->totQty_n = isset($row['totQty_n']) ? $row['totQty_n'] : '';
        $store->totQtyPrice = isset($row['totQtyPrice']) ? $row['totQtyPrice'] : '';
        $store->tot_productBuyPrice = isset($row['tot_productBuyPrice']) ? $row['tot_productBuyPrice'] : '';
        $store->tot_productBuyPrice_n = isset($row['tot_productBuyPrice_n']) ? $row['tot_productBuyPrice_n'] : '';
        $store->tot_productSellAllPrice = isset($row['tot_productSellAllPrice']) ? $row['tot_productSellAllPrice'] : '';
        $store->tot_productSellAllPrice_n = isset($row['tot_productSellAllPrice_n']) ? $row['tot_productSellAllPrice_n'] : '';
        $store->tot_productSellUnitPrice = isset($row['tot_productSellUnitPrice']) ? $row['tot_productSellUnitPrice'] : '';
        $store->tot_productSellUnitPrice_n = isset($row['tot_productSellUnitPrice_n']) ? $row['tot_productSellUnitPrice_n'] : '';
        $store->tot_productSellHalfPrice = isset($row['tot_productSellHalfPrice']) ? $row['tot_productSellHalfPrice'] : '';
        $store->tot_productSellHalfPrice_n = isset($row['tot_productSellHalfPrice_n']) ? $row['tot_productSellHalfPrice_n'] : '';
        $store->tot_lastbuyprice = isset($row['tot_lastbuyprice']) ? $row['tot_lastbuyprice'] : '';
        $store->tot_lastbuyprice_n = isset($row['tot_lastbuyprice_n']) ? $row['tot_lastbuyprice_n'] : '';
        $store->tot_lastbuyprice_withDiscount = isset($row['tot_lastbuyprice_withDiscount']) ? $row['tot_lastbuyprice_withDiscount'] : '';
        $store->tot_lastbuyprice_withDiscount_n = isset($row['tot_lastbuyprice_withDiscount_n']) ? $row['tot_lastbuyprice_withDiscount_n'] : '';
        $store->tot_meanbuyprice = isset($row['tot_meanbuyprice']) ? $row['tot_meanbuyprice'] : '';
        $store->tot_meanbuyprice_n = isset($row['tot_meanbuyprice_n']) ? $row['tot_meanbuyprice_n'] : '';
        $store->tot_meanbuyprice_withDiscount = isset($row['tot_meanbuyprice_withDiscount']) ? $row['tot_meanbuyprice_withDiscount'] : '';
        $store->tot_meanbuyprice_withDiscount_n = isset($row['tot_meanbuyprice_withDiscount_n']) ? $row['tot_meanbuyprice_withDiscount_n'] : '';
        $store->tot_lastbuyprice_withTax = isset($row['tot_lastbuyprice_withTax']) ? $row['tot_lastbuyprice_withTax'] : '';
        $store->tot_meanbuyprice_withTax = isset($row['tot_meanbuyprice_withTax']) ? $row['tot_meanbuyprice_withTax'] : '';

        return $store;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return StoreMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>