<?php

/**
 * Class that operate on table 'transferbtweenbankaccount'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-10-28 01:37
 */
class TransferbtweenbankaccountMySqlDAO implements TransferbtweenbankaccountDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TransferbtweenbankaccountMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM transferbtweenbankaccount';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM transferbtweenbankaccount ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param transferbtweenbankaccount primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TransferbtweenbankaccountMySql transferbtweenbankaccount
     */
    public function insert($transferbtweenbankaccount) {
        $sql = 'INSERT INTO transferbtweenbankaccount (bankidfrom, accountidfrom, bankidto, accountidto, transfervalue, transferdate, userid, conditions, dailyentryid, comment) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($transferbtweenbankaccount->bankidfrom);
        $sqlQuery->setNumber($transferbtweenbankaccount->accountidfrom);
        $sqlQuery->setNumber($transferbtweenbankaccount->bankidto);
        $sqlQuery->setNumber($transferbtweenbankaccount->accountidto);
        $sqlQuery->set($transferbtweenbankaccount->transfervalue);
        $sqlQuery->set($transferbtweenbankaccount->transferdate);
        $sqlQuery->setNumber($transferbtweenbankaccount->userid);
        $sqlQuery->setNumber($transferbtweenbankaccount->conditions);
        $sqlQuery->setNumber($transferbtweenbankaccount->dailyentryid);
        $sqlQuery->set($transferbtweenbankaccount->comment);

        $id = $this->executeInsert($sqlQuery);
        $transferbtweenbankaccount->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TransferbtweenbankaccountMySql transferbtweenbankaccount
     */
    public function update($transferbtweenbankaccount) {
        $sql = 'UPDATE transferbtweenbankaccount SET bankidfrom = ?, accountidfrom = ?, bankidto = ?, accountidto = ?, transfervalue = ?, transferdate = ?, userid = ?, conditions = ?, dailyentryid = ?, comment = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($transferbtweenbankaccount->bankidfrom);
        $sqlQuery->setNumber($transferbtweenbankaccount->accountidfrom);
        $sqlQuery->setNumber($transferbtweenbankaccount->bankidto);
        $sqlQuery->setNumber($transferbtweenbankaccount->accountidto);
        $sqlQuery->set($transferbtweenbankaccount->transfervalue);
        $sqlQuery->set($transferbtweenbankaccount->transferdate);
        $sqlQuery->setNumber($transferbtweenbankaccount->userid);
        $sqlQuery->setNumber($transferbtweenbankaccount->conditions);
        $sqlQuery->setNumber($transferbtweenbankaccount->dailyentryid);
        $sqlQuery->set($transferbtweenbankaccount->comment);

        $sqlQuery->setNumber($transferbtweenbankaccount->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM transferbtweenbankaccount';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBankidfrom($value) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE bankidfrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountidfrom($value) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE accountidfrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBankidto($value) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE bankidto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAccountidto($value) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE accountidto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTransfervalue($value) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE transfervalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTransferdate($value) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE transferdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM transferbtweenbankaccount WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBankidfrom($value) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE bankidfrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountidfrom($value) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE accountidfrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBankidto($value) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE bankidto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAccountidto($value) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE accountidto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTransfervalue($value) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE transfervalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTransferdate($value) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE transferdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM transferbtweenbankaccount WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TransferbtweenbankaccountMySql
     */
    protected function readRow($row) {
        $transferbtweenbankaccount = new Transferbtweenbankaccount();

        $transferbtweenbankaccount->id = $row['id'];
        $transferbtweenbankaccount->bankidfrom = $row['bankidfrom'];
        $transferbtweenbankaccount->accountidfrom = $row['accountidfrom'];
        $transferbtweenbankaccount->bankidto = $row['bankidto'];
        $transferbtweenbankaccount->accountidto = $row['accountidto'];
        $transferbtweenbankaccount->transfervalue = $row['transfervalue'];
        $transferbtweenbankaccount->transferdate = $row['transferdate'];
        $transferbtweenbankaccount->userid = $row['userid'];
        $transferbtweenbankaccount->conditions = $row['conditions'];
        $transferbtweenbankaccount->dailyentryid = $row['dailyentryid'];
        $transferbtweenbankaccount->comment = $row['comment'];
        //
        $transferbtweenbankaccount->bankNameFrom = $row['bankNameFrom'];
        $transferbtweenbankaccount->bankNameTo = $row['bankNameTo'];
        $transferbtweenbankaccount->accountNameFrom = $row['accountNameFrom'];
        $transferbtweenbankaccount->accountNameTo = $row['accountNameTo'];

        return $transferbtweenbankaccount;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TransferbtweenbankaccountMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>