<?php

/**
 * Class that operate on table 'transfermoney'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class TransfermoneyMySqlDAO implements TransfermoneyDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TransfermoneyMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM transfermoney WHERE transfermoneyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM transfermoney';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM transfermoney ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param transfermoney primary key
     */
    public function delete($transfermoneyid) {
        $sql = 'DELETE FROM transfermoney WHERE transfermoneyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($transfermoneyid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TransfermoneyMySql transfermoney
     */
    public function insert($transfermoney) {
        $sql = 'INSERT INTO transfermoney (saveidfrom, saveidto, transfermoneydate, userid, conditions, dailyentryid, comment, currencyIdSaveFrom, currencyIdSaveTo, conversionFactorFrom, conversionFactorTo, transfermoneyvalueInCurrencyFrom, transfermoneyvalueInCurrencyTo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($transfermoney->saveidfrom);
        $sqlQuery->setNumber($transfermoney->saveidto);
        $sqlQuery->set($transfermoney->transfermoneydate);
        $sqlQuery->setNumber($transfermoney->userid);
        $sqlQuery->setNumber($transfermoney->conditions);
        $sqlQuery->setNumber($transfermoney->dailyentryid);
        $sqlQuery->set($transfermoney->comment);
        $sqlQuery->setNumber((int) $transfermoney->currencyIdSaveFrom);
        $sqlQuery->setNumber((int) $transfermoney->currencyIdSaveTo);
        $sqlQuery->setNumber((float) $transfermoney->conversionFactorFrom);
        $sqlQuery->setNumber((float) $transfermoney->conversionFactorTo);
        $sqlQuery->setNumber((float) $transfermoney->transfermoneyvalueInCurrencyFrom);
        $sqlQuery->setNumber((float) $transfermoney->transfermoneyvalueInCurrencyTo);

        $id = $this->executeInsert($sqlQuery);
        $transfermoney->transfermoneyid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TransfermoneyMySql transfermoney
     */
    public function update($transfermoney) {
        $sql = 'UPDATE transfermoney SET saveidfrom = ?, saveidto = ?, transfermoneydate = ?, userid = ?, conditions = ?, dailyentryid = ?, comment = ?, currencyIdSaveFrom = ?, currencyIdSaveTo = ?, conversionFactorFrom = ?, conversionFactorTo = ?, transfermoneyvalueInCurrencyFrom = ?, transfermoneyvalueInCurrencyTo = ? WHERE transfermoneyid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($transfermoney->saveidfrom);
        $sqlQuery->setNumber($transfermoney->saveidto);
        $sqlQuery->set($transfermoney->transfermoneydate);
        $sqlQuery->setNumber($transfermoney->userid);
        $sqlQuery->setNumber($transfermoney->conditions);
        $sqlQuery->setNumber($transfermoney->dailyentryid);
        $sqlQuery->set($transfermoney->comment);
        $sqlQuery->setNumber((int) $transfermoney->currencyIdSaveFrom);
        $sqlQuery->setNumber((int) $transfermoney->currencyIdSaveTo);
        $sqlQuery->setNumber((float) $transfermoney->conversionFactorFrom);
        $sqlQuery->setNumber((float) $transfermoney->conversionFactorTo);
        $sqlQuery->setNumber((float) $transfermoney->transfermoneyvalueInCurrencyFrom);
        $sqlQuery->setNumber((float) $transfermoney->transfermoneyvalueInCurrencyTo);
        $sqlQuery->setNumber($transfermoney->transfermoneyid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM transfermoney';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySaveidfrom($value) {
        $sql = 'SELECT * FROM transfermoney WHERE saveidfrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveidto($value) {
        $sql = 'SELECT * FROM transfermoney WHERE saveidto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTransfermoneyvalue($value) {
        $sql = 'SELECT * FROM transfermoney WHERE transfermoneyvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTransfermoneydate($value) {
        $sql = 'SELECT * FROM transfermoney WHERE transfermoneydate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM transfermoney WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM transfermoney WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySaveidfrom($value) {
        $sql = 'DELETE FROM transfermoney WHERE saveidfrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveidto($value) {
        $sql = 'DELETE FROM transfermoney WHERE saveidto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTransfermoneyvalue($value) {
        $sql = 'DELETE FROM transfermoney WHERE transfermoneyvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTransfermoneydate($value) {
        $sql = 'DELETE FROM transfermoney WHERE transfermoneydate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM transfermoney WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM transfermoney WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TransfermoneyMySql
     */
    protected function readRow($row) {
        $transfermoney = new Transfermoney();

        $transfermoney->transfermoneyid = $row['transfermoneyid'];
        $transfermoney->saveidfrom = $row['saveidfrom'];
        $transfermoney->saveidto = $row['saveidto'];
        $transfermoney->transfermoneydate = $row['transfermoneydate'];
        $transfermoney->userid = $row['userid'];
        $transfermoney->conditions = $row['conditions'];
        $transfermoney->dailyentryid = $row['dailyentryid'];
        $transfermoney->comment = $row['comment'];
        $transfermoney->currencyIdSaveFrom = $row['currencyIdSaveFrom'];
        $transfermoney->currencyIdSaveTo = $row['currencyIdSaveTo'];
        $transfermoney->conversionFactorFrom = $row['conversionFactorFrom'];
        $transfermoney->conversionFactorTo = $row['conversionFactorTo'];
        $transfermoney->transfermoneyvalueInCurrencyFrom = $row['transfermoneyvalueInCurrencyFrom'];
        $transfermoney->transfermoneyvalueInCurrencyTo = $row['transfermoneyvalueInCurrencyTo'];
        //required
        $transfermoney->savefromname = (isset($row['savefromname'])) ? $row['savefromname'] : '';
        $transfermoney->savetoname = (isset($row['savetoname'])) ? $row['savetoname'] : '';

        return $transfermoney;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TransfermoneyMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>