<?php

/**
 * Class that operate on table 'usergroup'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class UsergroupMySqlExtDAO extends UsergroupMySqlDAO {

    public function loadusergroupname($id) {
        $sql = 'SELECT usergroupname FROM usergroup WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->querySingleResult($sqlQuery);
    }

    public function updateDel($usergroup) {
        $sql = 'UPDATE usergroup SET currentdate = ?, conditions = ? WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($usergroup->currentdate);
        $sqlQuery->setNumber($usergroup->conditions);

        $sqlQuery->setNumber($usergroup->usergroupid);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryAllwithOrder() {
        $sql = 'SELECT * FROM usergroup where usergroupid > 0 order by usergroupid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllnotdeleted() {
        $sql = 'SELECT * FROM usergroup where conditions=0 and usergroupid > 0 order by usergroupid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithName($usergroupname) {
        $sql = 'SELECT * FROM usergroup WHERE usergroupname ="' . $usergroupname . '"';
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function deletetemp($usergroupid) {
        $sql = 'UPDATE usergroup SET conditions = 1 WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($usergroupid);
        return $this->executeUpdate($sqlQuery);
    }

    public function returndelete($usergroupid) {
        $sql = 'UPDATE usergroup SET conditions = 0 WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($usergroupid);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryAllnotin($usersgroupids) {
        $sql = 'SELECT * FROM usergroup where
		 conditions=0
		 and usergroupid not in(' . $usersgroupids . ')
                     and usergroupid > 0
		 order by usergroupid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllarein($usersgroupids) {
        $sql = 'SELECT * FROM usergroup where
		 conditions=0
		 and usergroupid in(' . $usersgroupids . ')
                     and usergroupid > 0
		 order by usergroupid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function insertWithId($usergroup) {
        $sql = 'INSERT INTO usergroup (usergroupid,usergroupname, usergroupdescription, currentdate, conditions, startpage, level,savedailydate ,hidemenu,hidecat,clientnegative,suplliernegative,storenegative,directDiscount,percentageDiscount,priceupdate,allowEditDelInBills,allowEditDelInBuyBills,showsStorerQuantity,showSellAllPrice,showSellHalfPrice,showSellUnitPrice,showBuyPrice,productno,kempilano,productnotsellno,clientcheckno,suppliercheckno,productRequist,otherRequist,toWorkShopOrder,insuranceBill,sellreportpricetype ,netprofit , hideproductcatid ,directSaveBills,seeAllHalls,homePageIcon,sendKitchen,printKitchen,endBill,endPrintBill,showManualBackup,autoKitchenPrint,takeAway,delivery,hall,deleteMovementManage,allowBillDelete,billDeletePassword) VALUES (?,?,?, ?, ?, ?, ?, ?,?,? ,?,?,?,?,?,?,? ,? ,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($usergroup->usergroupid);
        $sqlQuery->set($usergroup->usergroupname);
        $sqlQuery->setString2($usergroup->usergroupdescription);
        $sqlQuery->set($usergroup->currentdate);
        $sqlQuery->setNumber($usergroup->conditions);
        $sqlQuery->set($usergroup->startpage);
        $sqlQuery->setNumber($usergroup->level);
        $sqlQuery->set($usergroup->savedailydate);
        $sqlQuery->setNumber($usergroup->hidemenu);
        $sqlQuery->setNumber($usergroup->hidecat);
        $sqlQuery->setNumber($usergroup->clientnegative);
        $sqlQuery->setNumber($usergroup->suplliernegative);
        $sqlQuery->setNumber($usergroup->storenegative);
        $sqlQuery->set($usergroup->directDiscount);
        $sqlQuery->set($usergroup->percentageDiscount);
        $sqlQuery->set($usergroup->priceupdate);
        $sqlQuery->setNumber($usergroup->allowEditDelInBills);
        $sqlQuery->setNumber($usergroup->allowEditDelInBuyBills);

        $sqlQuery->setNumber($usergroup->showsStorerQuantity);
        $sqlQuery->setNumber($usergroup->showSellAllPrice);
        $sqlQuery->setNumber($usergroup->showSellHalfPrice);
        $sqlQuery->setNumber($usergroup->showSellUnitPrice);
        $sqlQuery->setNumber($usergroup->showBuyPrice);

        $sqlQuery->setNumber($usergroup->productno);
        $sqlQuery->setNumber($usergroup->kempilano);
        $sqlQuery->setNumber($usergroup->productnotsellno);
        $sqlQuery->setNumber($usergroup->clientcheckno);
        $sqlQuery->setNumber($usergroup->suppliercheckno);
        $sqlQuery->setNumber($usergroup->productRequist);
        $sqlQuery->setNumber($usergroup->otherRequist);
        $sqlQuery->setNumber($usergroup->toWorkShopOrder);
        $sqlQuery->setNumber($usergroup->insuranceBill);
        $sqlQuery->setNumber($usergroup->sellreportpricetype);
        $sqlQuery->setNumber($usergroup->netprofit);
        $sqlQuery->setNumber($usergroup->hideproductcatid);
        $sqlQuery->setNumber($usergroup->directSaveBills);
        $sqlQuery->setNumber($usergroup->seeAllHalls);
        $sqlQuery->setNumber($usergroup->homePageIcon);
        $sqlQuery->setNumber($usergroup->sendKitchen);
        $sqlQuery->setNumber((int) $usergroup->printKitchen);
        $sqlQuery->setNumber($usergroup->endBill);
        $sqlQuery->setNumber($usergroup->endPrintBill);
        $sqlQuery->setNumber((int) $usergroup->showManualBackup);
        $sqlQuery->setNumber((int) $usergroup->autoKitchenPrint);
        $sqlQuery->setNumber((int) $usergroup->takeAway);
        $sqlQuery->setNumber((int) $usergroup->delivery);
        $sqlQuery->setNumber((int) $usergroup->hall);
        $sqlQuery->setNumber((int) $usergroup->deleteMovementManage);
        $sqlQuery->setNumber((int) $usergroup->allowBillDelete);
        $sqlQuery->set($usergroup->billDeletePassword);

        $id = $this->executeInsert($sqlQuery);
        $usergroup->usergroupid = $id;


        return $id;
    }

    public function queryByUsergroupBillDeletePassword($value) {
        $sql = 'SELECT * FROM usergroup WHERE billDeletePassword = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function updateByQueryString($updateQueryString) {
        $sql = $updateQueryString;
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

}

?>