<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Simple Database Test</h1>";

try {
    // Initialize database connection properly
    include("library/db_main/rb.php");
    include("models/sql/ConnectionProperty.class.php");
    
    $host = ConnectionProperty::getHost();
    $user = ConnectionProperty::getUser();
    $password = ConnectionProperty::getPassword();
    $database = ConnectionProperty::getDatabase();
    
    R::setup("mysql:host=$host;dbname=$database", $user, $password);
    
    $sql = "SELECT storedetailid, productid, storeid, productquantity FROM storedetail ORDER BY storedetailid DESC LIMIT 10";
    $result = R::getAll($sql);
    
    echo "<h2>Recent Stock Records:</h2>";
    echo "<table border='1'>";
    echo "<tr><th>StoreDetailID</th><th>ProductID</th><th>StoreID</th><th>Quantity</th></tr>";
    foreach ($result as $row) {
        echo "<tr><td>{$row['storedetailid']}</td><td>{$row['productid']}</td><td>{$row['storeid']}</td><td>{$row['productquantity']}</td></tr>";
    }
    echo "</table>";
    
    // Check storereport for stock movements
    $sql2 = "SELECT * FROM storereport ORDER BY storereportid DESC LIMIT 10";
    $result2 = R::getAll($sql2);
    
    echo "<h2>Recent Stock Movements (storereport):</h2>";
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>ProductID</th><th>StoreID</th><th>Quantity</th><th>Before</th><th>After</th><th>Type</th><th>ProcessName</th><th>Date</th></tr>";
    foreach ($result2 as $row) {
        echo "<tr>";
        echo "<td>{$row['storereportid']}</td>";
        echo "<td>{$row['productid']}</td>";
        echo "<td>{$row['storeid']}</td>";
        echo "<td>{$row['productquantity']}</td>";
        echo "<td>{$row['productbefore']}</td>";
        echo "<td>{$row['productafter']}</td>";
        echo "<td>{$row['storereporttype']}</td>";
        echo "<td>{$row['processname']}</td>";
        echo "<td>{$row['storereportdate']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Check sizecolorstoredetail table
    echo "<h2>Size/Color Store Detail:</h2>";
    $sql3 = "SELECT * FROM sizecolorstoredetail WHERE productid = 4 ORDER BY id DESC LIMIT 10";
    $result3 = R::getAll($sql3);
    echo "<pre>";
    print_r($result3);
    echo "</pre>";
    
} catch (Exception $e) {
    echo "<h1>Error:</h1>";
    echo "<pre>" . $e->getMessage() . "</pre>";
}
?>
