<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
include("public/impOpreation.php");
include("public/config.php");
include("public/include_dao.php");

require_once('models/dao/StoredetailDAO.class.php');
require_once('models/dto/Storedetail.class.php');
require_once('models/mysql/StoredetailMySqlDAO.class.php');
require_once('models/mysql/ext/StoredetailMySqlExtDAO.class.php');

$StoredetailEX = new StoredetailMySqlExtDAO();

// Get recent stock records
$sql = "SELECT storedetailid, productid, storeid, productquantity FROM storedetail ORDER BY storedetailid DESC LIMIT 10";
$result = R::getAll($sql);

echo "<h2>Recent Stock Records:</h2>";
echo "<table border='1'>";
echo "<tr><th>StoreDetailID</th><th>ProductID</th><th>StoreID</th><th>Quantity</th></tr>";
foreach ($result as $row) {
    echo "<tr><td>{$row['storedetailid']}</td><td>{$row['productid']}</td><td>{$row['storeid']}</td><td>{$row['productquantity']}</td></tr>";
}
echo "</table>";

// Test the query function
echo "<h2>Test Query Function:</h2>";
$productId = isset($_GET['pid']) ? $_GET['pid'] : 1;
$storeId = isset($_GET['sid']) ? $_GET['sid'] : 1;
$storeDetailData = $StoredetailEX->queryWithStoreAndProductandunit($productId, $storeId, 0);

echo "<pre>";
print_r($storeDetailData);
echo "</pre>";

} catch (Exception $e) {
    echo "<h1>Error:</h1>";
    echo "<pre>" . $e->getMessage() . "</pre>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>
